/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractionlist;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.swarm.fractionlist.FractionListParser;
import org.wildfly.swarm.tools.FractionDescriptor;

public class FractionList
implements org.wildfly.swarm.tools.FractionList {
    private final FractionListParser fractionListParser;
    private static final AtomicReference<FractionList> INSTANCE = new AtomicReference();

    public static FractionList get() {
        return INSTANCE.updateAndGet(old -> old != null ? old : new FractionList());
    }

    private FractionList() {
        try (InputStream fractionJsonStream = this.getClass().getClassLoader().getResourceAsStream("fraction-list.json");
             InputStream packageSpecStream = this.getClass().getClassLoader().getResourceAsStream("org/wildfly/swarm/fractionlist/fraction-packages.properties");){
            this.fractionListParser = new FractionListParser(fractionJsonStream, packageSpecStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<FractionDescriptor> getFractionDescriptors() {
        return this.fractionListParser.getFractionDescriptors();
    }

    @Override
    public FractionDescriptor getFractionDescriptor(String groupId, String artifactId) {
        return this.fractionListParser.getFractionDescriptor(groupId, artifactId);
    }

    @Override
    public Map<String, FractionDescriptor> getPackageSpecs() {
        return this.fractionListParser.getPackageSpecs();
    }
}

