/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractionlist;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.wildfly.swarm.tools.FractionDescriptor;
import org.wildfly.swarm.tools.FractionList;
import org.wildfly.swarm.tools.FractionStability;
import org.wildfly.swarm.tools.PropertiesUtil;

public class FractionListParser
implements FractionList {
    private final Map<String, FractionDescriptor> descriptors = new TreeMap<String, FractionDescriptor>();
    private final Map<String, String> packageSpecs = new HashMap<String, String>();

    public FractionListParser(InputStream fractionListJson, InputStream packageSpecStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(fractionListJson);){
            Json.parse(reader).asArray().forEach(entry -> {
                JsonObject fraction = entry.asObject();
                FractionDescriptor fd = this.getFractionDescriptor(fraction);
                this.addDependencies(fraction, fd);
            });
        }
        this.packageSpecs.putAll(PropertiesUtil.loadProperties(packageSpecStream));
    }

    private void addDependencies(JsonObject fraction, FractionDescriptor parent) {
        fraction.get("fractionDependencies").asArray().forEach(entry -> {
            JsonObject dependency = entry.asObject();
            FractionDescriptor descriptor = this.getFractionDescriptor(dependency);
            if (parent != null) {
                parent.addDependency(descriptor);
            }
            this.addDependencies(dependency, descriptor);
        });
    }

    private FractionDescriptor getFractionDescriptor(JsonObject fraction) {
        String groupId = this.toString(fraction.get("groupId"));
        String artifactId = this.toString(fraction.get("artifactId"));
        String key = groupId + ":" + artifactId;
        FractionDescriptor descriptor = this.descriptors.get(key);
        if (descriptor == null) {
            String version = this.toString(fraction.get("version"));
            String name = this.toString(fraction.get("name"));
            String description = this.toString(fraction.get("description"));
            String tags = this.toString(fraction.get("tags"));
            boolean internal = this.toBoolean(fraction.get("internal"));
            JsonValue stabilityIndexJson = fraction.get("stabilityIndex");
            int stabilityIndex = stabilityIndexJson == null || stabilityIndexJson.isNull() ? FractionStability.UNSTABLE.ordinal() : stabilityIndexJson.asInt();
            FractionStability stability = stabilityIndex < 0 || stabilityIndex >= FractionStability.values().length ? FractionStability.UNSTABLE : FractionStability.values()[stabilityIndex];
            descriptor = new FractionDescriptor(groupId, artifactId, version, name, description, tags, internal, stability);
            this.descriptors.put(key, descriptor);
        }
        return descriptor;
    }

    private boolean toBoolean(JsonValue jsonValue) {
        return jsonValue.isNull() ? false : jsonValue.asBoolean();
    }

    private String toString(JsonValue jsonValue) {
        return jsonValue.isNull() ? null : jsonValue.asString();
    }

    @Override
    public Collection<FractionDescriptor> getFractionDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    @Override
    public FractionDescriptor getFractionDescriptor(String groupId, String artifactId) {
        return this.descriptors.get(groupId + ":" + artifactId);
    }

    @Override
    public Map<String, FractionDescriptor> getPackageSpecs() {
        return this.descriptors.values().stream().filter(fd -> this.packageSpecs.containsKey(fd.getArtifactId())).collect(Collectors.toMap(fd -> this.packageSpecs.get(fd.getArtifactId()), fd -> fd));
    }
}

