/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Module {
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private String name;
    private String slot;
    private Boolean export;
    private ServiceHandling services;
    private Boolean optional = Boolean.FALSE;
    private String metaInf;
    private Map<String, List<String>> imports = new HashMap<String, List<String>>();
    private Map<String, List<String>> exports = new HashMap<String, List<String>>();

    Module(String name) {
        this(name, "main");
    }

    Module(String name, String slot) {
        this.name = name;
        this.slot = slot;
    }

    public String name() {
        return this.name;
    }

    Module withName(String name) {
        this.name = name;
        return this;
    }

    public String slot() {
        return this.slot;
    }

    Module withSlot(String slot) {
        this.slot = slot;
        return this;
    }

    public Boolean export() {
        return this.export;
    }

    public Module withExport(Boolean export) {
        this.export = export;
        return this;
    }

    public ServiceHandling services() {
        return this.services;
    }

    public Module withServices(ServiceHandling services) {
        this.services = services;
        return this;
    }

    public Boolean optional() {
        return this.optional;
    }

    public Module withOptional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    public String metaInf() {
        return this.metaInf;
    }

    public Module withMetaInf(String metaInf) {
        this.metaInf = metaInf;
        return this;
    }

    public List<String> importIncludePaths() {
        return this.imports.get(INCLUDE);
    }

    public List<String> importExcludePaths() {
        return this.imports.get(EXCLUDE);
    }

    public Module withImportIncludePath(String path) {
        this.checkList(this.imports, INCLUDE);
        this.imports.get(INCLUDE).add(path);
        return this;
    }

    public Module withImportExcludePath(String path) {
        this.checkList(this.imports, EXCLUDE);
        this.imports.get(EXCLUDE).add(path);
        return this;
    }

    public List<String> exportIncludePaths() {
        return this.exports.get(INCLUDE);
    }

    public List<String> exportExcludePaths() {
        return this.exports.get(EXCLUDE);
    }

    public Module withExportIncludePath(String path) {
        this.checkList(this.exports, INCLUDE);
        this.exports.get(INCLUDE).add(path);
        return this;
    }

    public Module withExportExcludePath(String path) {
        this.checkList(this.exports, EXCLUDE);
        this.exports.get(EXCLUDE).add(path);
        return this;
    }

    private void checkList(Map<String, List<String>> map, String key) {
        if (map.get(key) == null) {
            map.put(key, new ArrayList());
        }
    }

    public static enum ServiceHandling {
        NONE("none"),
        IMPORT("import"),
        EXPORT("export");

        private String value;

        private ServiceHandling(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

