/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.SimpleKey;

public class CompositeKey
implements ConfigKey {
    private final List<SimpleKey> parts = new ArrayList<SimpleKey>();

    public CompositeKey() {
    }

    public CompositeKey(SimpleKey ... parts) {
        this.parts.addAll(Arrays.asList(parts));
    }

    public CompositeKey(String ... parts) {
        this.parts.addAll(Arrays.asList(parts).stream().map(SimpleKey::new).collect(Collectors.toList()));
    }

    public CompositeKey(CompositeKey parent, ConfigKey child) {
        this.parts.addAll(parent.parts);
        if (child != ConfigKey.EMPTY) {
            if (child instanceof SimpleKey) {
                this.parts.add((SimpleKey)child);
            } else if (child instanceof CompositeKey) {
                this.parts.addAll(((CompositeKey)child).parts);
            }
        }
    }

    public CompositeKey(CompositeKey parent, String child) {
        this(parent, (ConfigKey)new SimpleKey(child));
    }

    CompositeKey(List<SimpleKey> parts) {
        this.parts.addAll(parts);
    }

    @Override
    public SimpleKey head() {
        if (this.parts.isEmpty()) {
            return ConfigKey.EMPTY;
        }
        return this.parts.get(0);
    }

    @Override
    public ConfigKey subkey(int offset) {
        if (this.parts.size() <= offset) {
            return ConfigKey.EMPTY;
        }
        List<SimpleKey> subParts = this.parts.subList(offset, this.parts.size());
        if (subParts.size() == 1) {
            return subParts.get(0);
        }
        return new CompositeKey(subParts);
    }

    @Override
    public String name() {
        return String.join((CharSequence)".", this.parts.stream().map(SimpleKey::propertyName).collect(Collectors.toList()));
    }

    @Override
    public String propertyName() {
        return String.join((CharSequence)".", this.parts.stream().map(SimpleKey::propertyName).collect(Collectors.toList()));
    }

    @Override
    public CompositeKey append(String ... names) {
        return this.append(ConfigKey.of(names));
    }

    @Override
    public CompositeKey append(ConfigKey key) {
        return new CompositeKey(this, key);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompositeKey) {
            return this.parts.equals(((CompositeKey)obj).parts);
        }
        return false;
    }

    public String toString() {
        return this.name();
    }
}

