/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import org.jboss.modules.maven.MavenResolver;
import org.wildfly.swarm.bootstrap.modules.GradleResolver;
import org.wildfly.swarm.bootstrap.modules.MultiMavenResolver;
import org.wildfly.swarm.bootstrap.modules.UberJarMavenResolver;

public class MavenResolvers {
    private static final MultiMavenResolver INSTANCE = new MultiMavenResolver();

    public static synchronized MavenResolver get() {
        return INSTANCE;
    }

    private MavenResolvers() {
    }

    static {
        INSTANCE.addResolver(new UberJarMavenResolver());
        if (System.getProperty("swarm.bundled.dependencies") == null) {
            Optional<String> gradleClassPathFile = Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).filter(name -> name.contains(".gradle")).findFirst();
            if (gradleClassPathFile.isPresent()) {
                String gradleCachePath = gradleClassPathFile.get().substring(0, gradleClassPathFile.get().indexOf("files-2.1") + 9);
                System.err.println("Dependencies not bundled, will resolve from gradle cache: " + gradleCachePath);
                INSTANCE.addResolver(new GradleResolver(gradleCachePath));
            } else {
                System.err.println("Dependencies not bundled, will resolve from local M2REPO");
                INSTANCE.addResolver(MavenResolver.createDefaultResolver());
            }
        }
    }
}

