/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.wildfly.swarm.fractions.FractionDescriptor;
import org.wildfly.swarm.fractions.FractionList;
import org.wildfly.swarm.fractions.scanner.ClassAndPackageScanner;
import org.wildfly.swarm.fractions.scanner.JarScanner;
import org.wildfly.swarm.fractions.scanner.Scanner;
import org.wildfly.swarm.fractions.scanner.WarScanner;
import org.wildfly.swarm.fractions.scanner.WebXmlDescriptorScanner;
import org.wildfly.swarm.spi.meta.FractionDetector;
import org.wildfly.swarm.spi.meta.SimpleLogger;

public class FractionUsageAnalyzer {
    private final List<File> sources = new ArrayList<File>();
    private final FractionList fractionList;
    private Collection<FractionDetector<?>> detectors = new HashSet();
    private Collection<Scanner<?>> scanners = new HashSet();
    private boolean detectorsLoaded = false;
    private SimpleLogger log = new SimpleLogger(){};

    public FractionUsageAnalyzer() {
        this(FractionList.get());
    }

    public FractionUsageAnalyzer(FractionList fractionList) {
        this.fractionList = fractionList;
    }

    public FractionUsageAnalyzer source(Path source) {
        this.source(source.toFile());
        return this;
    }

    public FractionUsageAnalyzer source(File source) {
        this.sources.add(source);
        return this;
    }

    public FractionUsageAnalyzer logger(SimpleLogger log) {
        this.log = log;
        return this;
    }

    public Collection<FractionDescriptor> detectNeededFractions() throws IOException {
        if (this.fractionList == null) {
            return Collections.emptySet();
        }
        this.loadDetectorsAndScanners();
        this.sources.forEach(this::scanFile);
        Collection detectedFractionNames = this.detectors.stream().filter(FractionDetector::wasDetected).map(FractionDetector::artifactId).distinct().collect(Collectors.toList());
        Collection detectedFractions = this.fractionList.getFractionDescriptors().stream().filter(fd -> detectedFractionNames.contains(fd.getArtifactId())).collect(Collectors.toList());
        Iterator it = detectedFractions.iterator();
        while (it.hasNext()) {
            FractionDescriptor descriptor = (FractionDescriptor)it.next();
            if (!detectedFractions.stream().anyMatch(fd -> fd.getDependencies().contains(descriptor))) continue;
            it.remove();
        }
        if (detectedFractions.isEmpty()) {
            detectedFractions.add(this.fractionList.getFractionDescriptor("org.wildfly.swarm", "container"));
        }
        return detectedFractions;
    }

    private void scanFile(File source) {
        this.fireScanner(this.suffix(source.getName()), s -> {
            try (ZipFile zip = new ZipFile(source);){
                s.scan(zip, this::scanSource);
            }
            catch (IOException e) {
                this.log.error("", e);
            }
        });
    }

    private void scanSource(ZipEntry entry, ZipFile source) {
        String suffix = this.suffix(entry.getName());
        Collection validDetectors = this.detectors.stream().filter(d -> d.extensionToDetect().equals(suffix)).filter(d -> !d.detectionComplete()).collect(Collectors.toList());
        if (validDetectors.size() > 0) {
            this.fireScanner(suffix, s -> {
                try (InputStream input = source.getInputStream(entry);){
                    s.scan(entry.getName(), input, this.convertDetectors(validDetectors), this::scanFile);
                }
                catch (IOException e) {
                    this.log.error("", e);
                }
            });
        }
    }

    private <T> Collection<FractionDetector<T>> convertDetectors(Collection<FractionDetector<?>> untypedDetectors) {
        HashSet detectors = new HashSet();
        untypedDetectors.forEach(d -> detectors.add(this.convert((FractionDetector<?>)d)));
        return detectors;
    }

    private <T> FractionDetector<T> convert(FractionDetector<?> detector) {
        return detector;
    }

    private void fireScanner(String suffix, Consumer<Scanner<?>> scannerConsumer) {
        this.scanners.stream().filter(s -> s.extension().equals(suffix)).findFirst().ifPresent(scannerConsumer);
    }

    private String suffix(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private void loadDetectorsAndScanners() {
        if (this.detectorsLoaded) {
            return;
        }
        ServiceLoader<FractionDetector> detectorLoader = ServiceLoader.load(FractionDetector.class);
        detectorLoader.forEach(d -> this.detectors.add((FractionDetector<?>)d));
        this.scanners.add(new WarScanner());
        this.scanners.add(new JarScanner());
        this.scanners.add(new ClassAndPackageScanner());
        this.scanners.add(new WebXmlDescriptorScanner());
        ClassAndPackageScanner.classesPackagesAlreadyDetected.clear();
        this.detectorsLoaded = true;
    }
}

