/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.spi.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.Pattern;
import org.jboss.shrinkwrap.descriptor.spi.node.Query;
import org.jboss.shrinkwrap.descriptor.spi.node.QueryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum AbsoluteGetQuery implements Query<List<Node>>
{
    INSTANCE;


    @Override
    public List<Node> execute(Node node, Pattern ... patterns) throws IllegalArgumentException {
        QueryUtil.validateNodeAndPatterns(node, patterns);
        return this.findMatch(node, Arrays.asList(patterns));
    }

    protected List<Node> findMatch(Node start, List<Pattern> patterns) {
        Pattern pattern = patterns.get(0);
        if (!pattern.matches(start)) {
            return Collections.emptyList();
        }
        ArrayList<Node> matchedNodes = new ArrayList<Node>();
        if (patterns.size() == 1) {
            matchedNodes.add(start);
            return matchedNodes;
        }
        for (Node child : start.getChildren()) {
            List<Pattern> remainingPatterns = patterns.subList(1, patterns.size());
            matchedNodes.addAll(this.findMatch(child, remainingPatterns));
        }
        return matchedNodes;
    }
}

