/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Exclusion;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.impl.maven.coordinate.MavenDependencyImpl;
import org.jboss.shrinkwrap.resolver.spi.MavenDependencySPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenConverter {
    private static final Logger log = Logger.getLogger(MavenConverter.class.getName());
    private static final String EMPTY = "";
    private static final MavenDependencyExclusion[] TYPESAFE_EXCLUSIONS_ARRAY = new MavenDependencyExclusion[0];

    private MavenConverter() {
        throw new UnsupportedOperationException("Utility class MavenConverter cannot be instantiated.");
    }

    public static MavenDependencyExclusion fromExclusion(Exclusion exclusion) {
        MavenDependencyExclusion translated = MavenDependencies.createExclusion(exclusion.getGroupId(), exclusion.getArtifactId());
        return translated;
    }

    public static MavenDependencyExclusion fromExclusion(org.eclipse.aether.graph.Exclusion exclusion) {
        MavenDependencyExclusion translated = MavenDependencies.createExclusion(exclusion.getGroupId(), exclusion.getArtifactId());
        return translated;
    }

    public static Set<MavenDependencyExclusion> fromExclusions(Collection<org.eclipse.aether.graph.Exclusion> exclusions) {
        LinkedHashSet<MavenDependencyExclusion> set = new LinkedHashSet<MavenDependencyExclusion>(exclusions.size());
        for (org.eclipse.aether.graph.Exclusion e : exclusions) {
            set.add(MavenConverter.fromExclusion(e));
        }
        return set;
    }

    public static String toCanonicalForm(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append(":");
        sb.append(artifact.getArtifactId()).append(":");
        PackagingType packaging = PackagingType.of(artifact.getProperty("type", artifact.getExtension()));
        String classifier = artifact.getClassifier().length() == 0 ? packaging.getClassifier() : artifact.getClassifier();
        sb.append(packaging.getId()).append(":");
        if (classifier.length() != 0) {
            sb.append(classifier).append(":");
        }
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static MavenDependency fromDependency(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        PackagingType packaging = PackagingType.of(artifact.getProperty("type", artifact.getExtension()));
        String classifier = artifact.getClassifier().length() == 0 ? packaging.getClassifier() : artifact.getClassifier();
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), packaging, classifier);
        ScopeType scope = ScopeType.RUNTIME;
        try {
            scope = ScopeType.fromScopeType(dependency.getScope());
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Invalid scope {0} of dependency {1} will be replaced by <scope>runtime</scope>", new Object[]{dependency.getScope(), coordinate.toCanonicalForm()});
        }
        MavenDependency result = MavenDependencies.createDependency(coordinate, scope, dependency.isOptional(), MavenConverter.fromExclusions(dependency.getExclusions()).toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return result;
    }

    public static Set<MavenDependency> fromDependencies(Collection<Dependency> dependencies) {
        LinkedHashSet<MavenDependency> set = new LinkedHashSet<MavenDependency>();
        for (Dependency d : dependencies) {
            set.add(MavenConverter.fromDependency(d));
        }
        return set;
    }

    public static MavenDependency fromDependency(org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry registry) {
        ArtifactType stereotype = registry.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        LinkedHashSet<MavenDependencyExclusion> exclusions = new LinkedHashSet<MavenDependencyExclusion>();
        for (Exclusion e : dependency.getExclusions()) {
            exclusions.add(MavenConverter.fromExclusion(e));
        }
        PackagingType packaging = PackagingType.of(artifact.getProperty("type", artifact.getExtension()));
        String classifier = artifact.getClassifier().length() == 0 ? packaging.getClassifier() : artifact.getClassifier();
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), packaging, classifier);
        String resolvedScope = dependency.getScope();
        boolean undeclaredScope = resolvedScope == null;
        ScopeType scope = ScopeType.RUNTIME;
        try {
            scope = ScopeType.fromScopeType(resolvedScope);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Invalid scope {0} of dependency {1} will be replaced by <scope>runtime</scope>", new Object[]{dependency.getScope(), coordinate.toCanonicalForm()});
        }
        MavenDependencyImpl result = new MavenDependencyImpl(coordinate, scope, dependency.isOptional(), undeclaredScope, exclusions.toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return result;
    }

    public static Set<MavenDependency> fromDependencies(Collection<org.apache.maven.model.Dependency> dependencies, ArtifactTypeRegistry registry) {
        LinkedHashSet<MavenDependency> set = new LinkedHashSet<MavenDependency>();
        for (org.apache.maven.model.Dependency d : dependencies) {
            set.add(MavenConverter.fromDependency(d, registry));
        }
        return set;
    }

    public static Dependency asDependency(MavenDependencySPI dependency, ArtifactTypeRegistry registry) {
        String scope = dependency.getScope().toString();
        if (dependency.isUndeclaredScope()) {
            scope = EMPTY;
        }
        return new Dependency(MavenConverter.asArtifact(dependency, registry), scope, dependency.isOptional(), MavenConverter.asExclusions(dependency.getExclusions()));
    }

    public static List<Dependency> asDependencies(List<MavenDependency> dependencies, ArtifactTypeRegistry registry) {
        ArrayList<Dependency> list = new ArrayList<Dependency>(dependencies.size());
        for (MavenDependency d : dependencies) {
            list.add(MavenConverter.asDependency((MavenDependencySPI)d, registry));
        }
        return list;
    }

    public static Artifact asArtifact(MavenCoordinate coordinate, ArtifactTypeRegistry registry) throws CoordinateParseException {
        try {
            return new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getPackaging().getExtension(), coordinate.getVersion(), registry.get(coordinate.getPackaging().getId()));
        }
        catch (IllegalArgumentException e) {
            throw new CoordinateParseException("Unable to create artifact from invalid coordinates " + coordinate.toCanonicalForm());
        }
    }

    public static org.eclipse.aether.graph.Exclusion asExclusion(MavenDependencyExclusion coordinates) {
        String group = coordinates.getGroupId();
        String artifact = coordinates.getArtifactId();
        group = group == null || group.length() == 0 ? "*" : group;
        artifact = artifact == null || artifact.length() == 0 ? "*" : artifact;
        return new org.eclipse.aether.graph.Exclusion(group, artifact, "*", "*");
    }

    public static List<org.eclipse.aether.graph.Exclusion> asExclusions(Collection<MavenDependencyExclusion> exclusions) {
        ArrayList<org.eclipse.aether.graph.Exclusion> list = new ArrayList<org.eclipse.aether.graph.Exclusion>(exclusions.size());
        for (MavenDependencyExclusion coords : exclusions) {
            list.add(MavenConverter.asExclusion(coords));
        }
        return list;
    }

    public static RemoteRepository asRemoteRepository(org.apache.maven.model.Repository repository) {
        return new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).setSnapshotPolicy(MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setReleasePolicy(MavenConverter.asRepositoryPolicy(repository.getReleases())).build();
    }

    public static RemoteRepository asRemoteRepository(Repository repository) {
        return new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).setSnapshotPolicy(MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setReleasePolicy(MavenConverter.asRepositoryPolicy(repository.getReleases())).build();
    }

    public static Proxy asProxy(org.apache.maven.settings.Proxy proxy) {
        Authentication authentication = proxy.getUsername() != null || proxy.getPassword() != null ? new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build() : null;
        return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authentication);
    }

    public static org.apache.maven.model.Profile asProfile(Profile profile) {
        org.apache.maven.model.Profile mavenProfile = new org.apache.maven.model.Profile();
        if (profile != null) {
            mavenProfile.setId(profile.getId());
            mavenProfile.setActivation(MavenConverter.asActivation(profile.getActivation()));
            mavenProfile.setProperties(profile.getProperties());
            mavenProfile.setRepositories(MavenConverter.asRepositories(profile.getRepositories()));
            mavenProfile.setPluginRepositories(MavenConverter.asRepositories(profile.getPluginRepositories()));
        }
        return mavenProfile;
    }

    public static List<org.apache.maven.model.Profile> asProfiles(List<Profile> profiles) {
        ArrayList<org.apache.maven.model.Profile> mavenProfiles = new ArrayList<org.apache.maven.model.Profile>();
        for (Profile p : profiles) {
            mavenProfiles.add(MavenConverter.asProfile(p));
        }
        return mavenProfiles;
    }

    private static org.apache.maven.model.Repository asRepository(Repository repository) {
        org.apache.maven.model.Repository mavenRepository = new org.apache.maven.model.Repository();
        if (repository != null) {
            mavenRepository.setId(repository.getId());
            mavenRepository.setLayout(repository.getLayout());
            mavenRepository.setName(repository.getName());
            mavenRepository.setUrl(repository.getUrl());
            mavenRepository.setReleases(MavenConverter.asMavenRepositoryPolicy(repository.getReleases()));
            mavenRepository.setSnapshots(MavenConverter.asMavenRepositoryPolicy(repository.getSnapshots()));
        }
        return mavenRepository;
    }

    private static List<org.apache.maven.model.Repository> asRepositories(List<Repository> repositories) {
        ArrayList<org.apache.maven.model.Repository> mavenRepositories = new ArrayList<org.apache.maven.model.Repository>();
        for (Repository repository : repositories) {
            mavenRepositories.add(MavenConverter.asRepository(repository));
        }
        return mavenRepositories;
    }

    private static Activation asActivation(org.apache.maven.settings.Activation activation) {
        Activation mavenActivation = new Activation();
        if (activation != null) {
            mavenActivation.setActiveByDefault(activation.isActiveByDefault());
            mavenActivation.setJdk(activation.getJdk());
            if (activation.getFile() != null) {
                mavenActivation.setFile(MavenConverter.asActivationFile(activation.getFile()));
            }
            if (activation.getOs() != null) {
                mavenActivation.setOs(MavenConverter.asActivationOS(activation.getOs()));
            }
            if (activation.getProperty() != null) {
                mavenActivation.setProperty(MavenConverter.asActivationProperty(activation.getProperty()));
            }
        }
        return mavenActivation;
    }

    private static org.apache.maven.model.ActivationFile asActivationFile(ActivationFile file) {
        org.apache.maven.model.ActivationFile mavenActivationFile = new org.apache.maven.model.ActivationFile();
        if (file != null) {
            mavenActivationFile.setExists(file.getExists());
            mavenActivationFile.setMissing(file.getMissing());
        }
        return mavenActivationFile;
    }

    private static ActivationOS asActivationOS(org.apache.maven.settings.ActivationOS os) {
        ActivationOS mavenOS = new ActivationOS();
        if (os != null) {
            mavenOS.setArch(os.getArch());
            mavenOS.setFamily(os.getFamily());
            mavenOS.setName(os.getName());
            mavenOS.setVersion(os.getVersion());
        }
        return mavenOS;
    }

    private static ActivationProperty asActivationProperty(org.apache.maven.settings.ActivationProperty property) {
        ActivationProperty mavenProperty = new ActivationProperty();
        if (property != null) {
            mavenProperty.setName(property.getName());
            mavenProperty.setValue(property.getValue());
        }
        return mavenProperty;
    }

    private static RepositoryPolicy asRepositoryPolicy(org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    private static RepositoryPolicy asRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    private static org.apache.maven.model.RepositoryPolicy asMavenRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy policy) {
        org.apache.maven.model.RepositoryPolicy mavenPolicy = new org.apache.maven.model.RepositoryPolicy();
        if (policy != null) {
            mavenPolicy.setChecksumPolicy(policy.getChecksumPolicy());
            mavenPolicy.setUpdatePolicy(policy.getUpdatePolicy());
            mavenPolicy.setEnabled(policy.isEnabled());
        }
        return mavenPolicy;
    }
}

