/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.impl.maven.coordinate.MavenDependencyImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveVersionFromMetadataTask
implements MavenWorkingSessionTask<String> {
    private static final Logger log = Logger.getLogger(ResolveVersionFromMetadataTask.class.getName());
    private final MavenDependency dependency;

    public ResolveVersionFromMetadataTask(MavenDependency dependency) {
        this.dependency = dependency;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String execute(MavenWorkingSession session) {
        String declaredVersion = this.dependency.getVersion();
        String resolvedVersion = declaredVersion;
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion) && session.getDependencyManagement().contains(this.dependency)) {
            void var4_5;
            Object var4_4 = null;
            for (MavenDependency mavenDependency : session.getDependencyManagement()) {
                if (mavenDependency.equals(this.dependency)) break;
            }
            resolvedVersion = var4_5.getVersion();
            log.log(Level.FINE, "Resolved version {0} from the POM file for the artifact {1}", new Object[]{var4_5.getVersion(), this.dependency.toCanonicalForm()});
        }
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion) && this.dependency.getPackaging().equals(PackagingType.JAR) && this.dependency.getClassifier().equals(PackagingType.TEST_JAR.getClassifier())) {
            MavenCoordinate mavenCoordinate = MavenCoordinates.createCoordinate(this.dependency.getGroupId(), this.dependency.getArtifactId(), this.dependency.getVersion(), PackagingType.TEST_JAR, PackagingType.TEST_JAR.getClassifier());
            MavenDependencyImpl newDependency = new MavenDependencyImpl(mavenCoordinate, this.dependency.getScope(), this.dependency.isOptional(), this.dependency.getExclusions().toArray(new MavenDependencyExclusion[0]));
            if (session.getDependencyManagement().contains(newDependency)) {
                void var6_12;
                Object var6_11 = null;
                for (MavenDependency mavenDependency : session.getDependencyManagement()) {
                    if (mavenDependency.equals(newDependency)) break;
                }
                resolvedVersion = var6_12.getVersion();
                log.log(Level.FINE, "Resolved version {0} from the POM file for the artifact {1} via {2}", new Object[]{var6_12.getVersion(), this.dependency.toCanonicalForm(), newDependency.toCanonicalForm()});
            }
        }
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion)) {
            if (log.isLoggable(Level.FINER)) {
                StringBuilder stringBuilder = new StringBuilder("Available version management: \n");
                for (MavenDependency mavenDependency : session.getDependencyManagement()) {
                    stringBuilder.append(mavenDependency).append("\n");
                }
                log.log(Level.FINER, stringBuilder.toString());
            }
            throw new ResolutionException(MessageFormat.format("Unable to get version for dependency specified by {0}, it was not provided in neither <dependencyManagement> nor <dependencies> sections.", this.dependency.toCanonicalForm()));
        }
        return resolvedVersion;
    }
}

