/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.meta;

import java.io.InputStream;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.wildfly.swarm.spi.meta.FractionDetector;

public abstract class WebXmlDescriptorFractionDetector
implements FractionDetector<InputStream> {
    private boolean detected = false;
    private boolean detectionComplete = false;
    protected WebAppDescriptor webXMl;

    @Override
    public String extensionToDetect() {
        return "xml";
    }

    @Override
    public boolean detectionComplete() {
        return this.detectionComplete;
    }

    @Override
    public boolean wasDetected() {
        return this.detected;
    }

    @Override
    public void detect(InputStream element) {
        if (!this.detectionComplete() && element != null) {
            this.webXMl = Descriptors.importAs(WebAppDescriptor.class).fromStream(element);
            if (this.webXMl != null && this.doDetect()) {
                this.detected = true;
                this.detectionComplete = true;
            }
        }
    }

    protected abstract boolean doDetect();
}

