/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.spi.node.dom;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExportException;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptor;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorExporterImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XmlDomDescriptorExporterImpl
extends NodeDescriptorExporterImpl
implements DescriptorExporter<NodeDescriptor> {
    XmlDomDescriptorExporterImpl() {
    }

    @Override
    public void to(Node node, OutputStream out) throws DescriptorExportException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document root = builder.newDocument();
            root.setXmlStandalone(true);
            this.writeRecursive(root, node);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            StreamResult result = new StreamResult(out);
            transformer.transform(new DOMSource(root), result);
        }
        catch (Exception e) {
            throw new DescriptorExportException("Could not export Node structure to XML", e);
        }
    }

    private void writeRecursive(org.w3c.dom.Node target, Node source) {
        Document owned = target.getOwnerDocument();
        if (owned == null) {
            owned = (Document)target;
        }
        org.w3c.dom.Node targetChild = null;
        if (source.isComment()) {
            targetChild = owned.createComment(source.getText());
        } else if (source.getText() != null) {
            targetChild = owned.createElement(source.getName());
            targetChild.appendChild(owned.createTextNode(source.getText()));
        } else {
            targetChild = owned.createElement(source.getName());
        }
        target.appendChild(targetChild);
        for (Map.Entry<String, String> attribute : source.getAttributes().entrySet()) {
            Attr attr = owned.createAttribute(attribute.getKey());
            attr.setValue(attribute.getValue());
            targetChild.getAttributes().setNamedItem(attr);
        }
        for (Node sourceChild : source.getChildren()) {
            this.writeRecursive(targetChild, sourceChild);
        }
    }
}

