/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractions.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.wildfly.swarm.spi.meta.FractionDetector;
import org.wildfly.swarm.spi.meta.PathSource;
import org.wildfly.swarm.spi.meta.ZipPathSource;

public interface Scanner<T> {
    public String extension();

    default public void scan(PathSource fileSource, Collection<FractionDetector<T>> detectors, Consumer<File> handleFileAsZip) throws IOException {
    }

    default public void scan(ZipEntry entry, ZipFile source, Collection<FractionDetector<T>> detectors, Consumer<File> handleFileAsZip) throws IOException {
        this.scan(new ZipPathSource(source, entry), detectors, handleFileAsZip);
    }

    default public void copy(InputStream input, OutputStream output) throws IOException {
        int n = 0;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }
}

