/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jsf.detect;

import java.io.File;
import org.wildfly.swarm.spi.meta.FileDetector;
import org.wildfly.swarm.spi.meta.PathSource;

public class FacesXmlDetector
extends FileDetector {
    private static final String XML = "xml";
    private static final String FACES_CONFIG_XML_WEB_INF = "WEB-INF" + File.separator + "faces-config.xml";
    private static final String FACES_CONFIG_XML_META_INF = "META-INF" + File.separator + "faces-config.xml";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String JSF = "jsf";
    private boolean detected = false;
    private boolean detectionComplete = false;

    @Override
    public String extensionToDetect() {
        return XML;
    }

    @Override
    public boolean detectionComplete() {
        return this.detectionComplete;
    }

    @Override
    public boolean wasDetected() {
        return this.detected;
    }

    @Override
    public void detect(PathSource fileSource) {
        String relativePath = fileSource.getRelativePath();
        if (!this.detectionComplete() && (relativePath.equals(FACES_CONFIG_XML_WEB_INF) || relativePath.equals(FACES_CONFIG_XML_META_INF) || relativePath.endsWith(FACES_CONFIG_SUFFIX))) {
            this.detected = true;
            this.detectionComplete = true;
        }
    }

    @Override
    public String artifactId() {
        return JSF;
    }
}

