/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.NonTransitiveStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenStrategyStageBaseImpl<STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
implements MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>,
MavenWorkingSessionContainer {
    private static final Logger log = Logger.getLogger(MavenStrategyStageBaseImpl.class.getName());
    private final MavenWorkingSession session;

    public MavenStrategyStageBaseImpl(MavenWorkingSession session) {
        this.session = session;
    }

    @Override
    public FORMATSTAGETYPE withTransitivity() {
        return this.using(TransitiveStrategy.INSTANCE);
    }

    @Override
    public FORMATSTAGETYPE withoutTransitivity() {
        return this.using(NonTransitiveStrategy.INSTANCE);
    }

    @Override
    public MavenWorkingSession getMavenWorkingSession() {
        return this.session;
    }

    @Override
    public FORMATSTAGETYPE using(MavenResolutionStrategy strategy) throws IllegalArgumentException {
        Validate.notEmpty(this.session.getDependenciesForResolution(), "No dependencies were set for resolution");
        Collection<MavenResolvedArtifact> resolvedArtifacts = this.session.resolveDependencies(strategy);
        return this.createFormatStage(resolvedArtifacts);
    }

    @Override
    public STRATEGYSTAGETYPE withClassPathResolution(boolean useClassPathResolution) {
        log.log(Level.WARNING, "Using deprecated withClassPathResolution(boolean) method, that might be activated after pom.xml resolution. Please configure classpath resolution via Maven.configureResolver() call instead.");
        if (!useClassPathResolution) {
            this.session.disableClassPathWorkspaceReader();
        }
        return this.covarientReturn();
    }

    @Override
    public STRATEGYSTAGETYPE withMavenCentralRepo(boolean useMavenCentral) {
        log.log(Level.WARNING, "Using deprecated withMavenCentralRepo(boolean) method, that might be activated after pom.xml resolution. Please configure Maven Central repository via Maven.configureResolver() call instead.");
        if (!useMavenCentral) {
            this.session.disableMavenCentral();
        }
        return this.covarientReturn();
    }

    private STRATEGYSTAGETYPE covarientReturn() {
        return (STRATEGYSTAGETYPE)((MavenStrategyStageBase)this.getActualClass().cast(this));
    }

    protected abstract Class<STRATEGYSTAGETYPE> getActualClass();

    protected abstract FORMATSTAGETYPE createFormatStage(Collection<MavenResolvedArtifact> var1);
}

