/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPackageScanner {
    private static final Logger log = Logger.getLogger(URLPackageScanner.class.getName());
    private static final String SUFFIX_CLASS = ".class";
    private static final String WEB_INF_CLASSES_DIR = "WEB-INF/classes/";
    private final String packageName;
    private final String packageNamePath;
    private final boolean addRecursively;
    private final ClassLoader classLoader;
    private String prefix;
    private Callback callback;

    public static URLPackageScanner newInstance(boolean addRecursively, ClassLoader classLoader, Callback callback, String packageName) {
        Validate.notNull(packageName, "Package name must be specified");
        Validate.notNull(addRecursively, "AddRecursively must be specified");
        Validate.notNull(classLoader, "ClassLoader must be specified");
        Validate.notNull(callback, "Callback must be specified");
        return new URLPackageScanner(packageName, addRecursively, classLoader, callback);
    }

    private URLPackageScanner(String packageName, boolean addRecursively, ClassLoader classLoader, Callback callback) {
        this.packageName = packageName;
        this.packageNamePath = packageName.replace(".", "/");
        this.addRecursively = addRecursively;
        this.classLoader = classLoader;
        this.callback = callback;
        this.prefix = "";
    }

    public void scanPackage() {
        try {
            HashSet<String> paths = new HashSet<String>();
            for (URL url : this.loadResources(this.packageNamePath)) {
                String urlPath = url.getFile();
                if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                paths.add(urlPath);
            }
            this.handle(paths);
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "could not read: " + this.packageName, ioe);
        }
        catch (ClassNotFoundException ioe) {
            log.log(Level.WARNING, "Class coud not be loaded in package: " + this.packageName, ioe);
        }
    }

    private void handleArchiveByFile(File file) throws IOException, ClassNotFoundException {
        try {
            log.fine("archive: " + file);
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(this.prefix + this.packageNamePath) || !name.endsWith(SUFFIX_CLASS) || !this.addRecursively && name.substring((this.prefix + this.packageNamePath).length() + 1).contains("/")) continue;
                String className = name.replace("/", ".").substring(this.prefix.length(), name.length() - SUFFIX_CLASS.length());
                this.foundClass(className, name);
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handle(Set<String> paths) throws IOException, ClassNotFoundException {
        for (String urlPath : paths) {
            log.fine("scanning: " + urlPath);
            File file = new File(urlPath);
            if (file.isDirectory()) {
                this.handle(file, this.packageName);
                continue;
            }
            this.handleArchiveByFile(file);
        }
    }

    private void handle(File file, String packageName) throws ClassNotFoundException {
        for (File child : file.listFiles()) {
            if (!child.isDirectory() && child.getName().endsWith(SUFFIX_CLASS)) {
                String packagePrefix = packageName.length() > 0 ? packageName + "." : packageName;
                String className = packagePrefix + child.getName().substring(0, child.getName().lastIndexOf(SUFFIX_CLASS));
                this.foundClass(className, this.prefix + className.replace('.', '/') + SUFFIX_CLASS);
                continue;
            }
            if (!child.isDirectory() || !this.addRecursively) continue;
            this.handle(child, packageName + "." + child.getName());
        }
    }

    private void foundClass(String className, String path) {
        this.callback.classFound(className, new ClassLoaderAsset(path, this.classLoader));
    }

    private List<URL> loadResources(String name) throws IOException {
        ArrayList<URL> resources = Collections.list(this.classLoader.getResources(this.prefix + name));
        if (resources.size() == 0) {
            this.prefix = WEB_INF_CLASSES_DIR;
            resources = Collections.list(this.classLoader.getResources(this.prefix + name));
        } else {
            for (URL url : resources) {
                if (!url.toString().contains(WEB_INF_CLASSES_DIR)) continue;
                this.prefix = WEB_INF_CLASSES_DIR;
                break;
            }
        }
        return resources;
    }

    public static interface Callback {
        public void classFound(String var1, Asset var2);
    }
}

