/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.ProjectAsset;

public class ArtifactAsset
implements ProjectAsset {
    private final ArtifactSpec spec;
    private final String artifactName;

    public ArtifactAsset(ArtifactSpec spec, String artifactName) {
        this.spec = spec;
        this.artifactName = artifactName;
    }

    @Override
    public String getSimpleName() {
        if (this.artifactName != null) {
            return this.artifactName;
        }
        String version = this.spec.version();
        return String.format("%s%s.%s", this.spec.artifactId(), version == null || version.isEmpty() ? "" : "-" + version, this.spec.type());
    }

    @Override
    public InputStream openStream() {
        try {
            return new FileInputStream(this.spec.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Archive<?> getArchive() {
        return ShrinkWrap.createFromZipFile(JavaArchive.class, this.spec.file);
    }
}

