/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.jbosscommon60;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.InjectionTargetType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.ResourceEnvRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.InjectionTargetTypeImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceEnvRefTypeImpl<T>
implements Child<T>,
ResourceEnvRefType<T> {
    private T t;
    private Node childNode;

    public ResourceEnvRefTypeImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public ResourceEnvRefTypeImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    @Override
    public T up() {
        return this.t;
    }

    @Override
    public ResourceEnvRefType<T> jndiName(String jndiName) {
        this.childNode.getOrCreate("jndi-name").text(jndiName);
        return this;
    }

    @Override
    public String getJndiName() {
        return this.childNode.getTextValueForPatternName("jndi-name");
    }

    @Override
    public ResourceEnvRefType<T> removeJndiName() {
        this.childNode.removeChildren("jndi-name");
        return this;
    }

    @Override
    public ResourceEnvRefType<T> mappedName(String mappedName) {
        this.childNode.getOrCreate("mapped-name").text(mappedName);
        return this;
    }

    @Override
    public String getMappedName() {
        return this.childNode.getTextValueForPatternName("mapped-name");
    }

    @Override
    public ResourceEnvRefType<T> removeMappedName() {
        this.childNode.removeChildren("mapped-name");
        return this;
    }

    @Override
    public InjectionTargetType<ResourceEnvRefType<T>> getOrCreateInjectionTarget() {
        List<Node> nodeList = this.childNode.get("injection-target");
        if (nodeList != null && nodeList.size() > 0) {
            return new InjectionTargetTypeImpl<ResourceEnvRefType<T>>(this, "injection-target", this.childNode, nodeList.get(0));
        }
        return this.createInjectionTarget();
    }

    @Override
    public InjectionTargetType<ResourceEnvRefType<T>> createInjectionTarget() {
        return new InjectionTargetTypeImpl<ResourceEnvRefType<T>>(this, "injection-target", this.childNode);
    }

    @Override
    public List<InjectionTargetType<ResourceEnvRefType<T>>> getAllInjectionTarget() {
        ArrayList<InjectionTargetType<ResourceEnvRefType<T>>> list = new ArrayList<InjectionTargetType<ResourceEnvRefType<T>>>();
        List<Node> nodeList = this.childNode.get("injection-target");
        for (Node node : nodeList) {
            InjectionTargetTypeImpl<ResourceEnvRefTypeImpl> type = new InjectionTargetTypeImpl<ResourceEnvRefTypeImpl>(this, "injection-target", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    @Override
    public ResourceEnvRefType<T> removeAllInjectionTarget() {
        this.childNode.removeChildren("injection-target");
        return this;
    }

    @Override
    public ResourceEnvRefType<T> ignoreDependency() {
        this.childNode.getOrCreate("ignore-dependency");
        return this;
    }

    @Override
    public Boolean isIgnoreDependency() {
        return this.childNode.getSingle("ignore-dependency") != null;
    }

    @Override
    public ResourceEnvRefType<T> removeIgnoreDependency() {
        this.childNode.removeChild("ignore-dependency");
        return this;
    }

    @Override
    public ResourceEnvRefType<T> description(String ... values) {
        if (values != null) {
            for (String name : values) {
                this.childNode.createChild("description").text(name);
            }
        }
        return this;
    }

    @Override
    public List<String> getAllDescription() {
        ArrayList<String> result = new ArrayList<String>();
        List<Node> nodes = this.childNode.get("description");
        for (Node node : nodes) {
            result.add(node.getText());
        }
        return result;
    }

    @Override
    public ResourceEnvRefType<T> removeAllDescription() {
        this.childNode.removeChildren("description");
        return this;
    }

    @Override
    public ResourceEnvRefType<T> resourceEnvRefName(String resourceEnvRefName) {
        this.childNode.getOrCreate("resource-env-ref-name").text(resourceEnvRefName);
        return this;
    }

    @Override
    public String getResourceEnvRefName() {
        return this.childNode.getTextValueForPatternName("resource-env-ref-name");
    }

    @Override
    public ResourceEnvRefType<T> removeResourceEnvRefName() {
        this.childNode.removeChildren("resource-env-ref-name");
        return this;
    }

    @Override
    public ResourceEnvRefType<T> resourceEnvRefType(String resourceEnvRefType) {
        this.childNode.getOrCreate("resource-env-ref-type").text(resourceEnvRefType);
        return this;
    }

    @Override
    public String getResourceEnvRefType() {
        return this.childNode.getTextValueForPatternName("resource-env-ref-type");
    }

    @Override
    public ResourceEnvRefType<T> removeResourceEnvRefType() {
        this.childNode.removeChildren("resource-env-ref-type");
        return this;
    }

    @Override
    public ResourceEnvRefType<T> id(String id) {
        this.childNode.attribute("id", id);
        return this;
    }

    @Override
    public String getId() {
        return this.childNode.getAttribute("id");
    }

    @Override
    public ResourceEnvRefType<T> removeId() {
        this.childNode.removeAttribute("id");
        return this;
    }
}

