/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.ResourceAdapterContainer;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceAdapterContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements ResourceAdapterContainer<T> {
    protected ResourceAdapterContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    @Override
    public T setResourceAdapterXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.setResourceAdapterXML(new ClassLoaderAsset(resourceName));
    }

    @Override
    public T setResourceAdapterXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setResourceAdapterXML(new FileAsset(resource));
    }

    @Override
    public T setResourceAdapterXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setResourceAdapterXML(new UrlAsset(resource));
    }

    @Override
    public T setResourceAdapterXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsManifestResource(resource, "ra.xml");
    }

    @Override
    public T setResourceAdapterXML(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addAsManifestResource(resourcePackage, resourceName, "ra.xml");
    }
}

