/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.wildfly.swarm.bootstrap.Main;
import org.wildfly.swarm.bootstrap.env.WildFlySwarmManifest;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.fractions.FractionDescriptor;
import org.wildfly.swarm.fractions.FractionList;
import org.wildfly.swarm.fractions.FractionUsageAnalyzer;
import org.wildfly.swarm.spi.meta.SimpleLogger;
import org.wildfly.swarm.tools.ArchiveAsset;
import org.wildfly.swarm.tools.ArtifactAsset;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;
import org.wildfly.swarm.tools.DefaultArtifactResolver;
import org.wildfly.swarm.tools.DependencyManager;
import org.wildfly.swarm.tools.ProjectAsset;
import org.wildfly.swarm.tools.ResolvedDependencies;
import org.wildfly.swarm.tools.WebInfLibFilteringArchive;
import org.wildfly.swarm.tools.WebInfLibFilteringArchiveAsset;
import org.wildfly.swarm.tools.ZipFileHeaderAsset;

public class BuildTool {
    private final Set<ArtifactSpec> fractions = new HashSet<ArtifactSpec>();
    private final JavaArchive archive;
    private final Set<String> resourceDirectories = new HashSet<String>();
    private Path uberjarResourcesDirectory = null;
    private String mainClass;
    private String testClass;
    private boolean bundleDependencies = true;
    private boolean executable;
    private File executableScript;
    private DependencyManager dependencyManager;
    private ProjectAsset projectAsset;
    private Properties properties = new Properties();
    private Set<String> additionalModules = new HashSet<String>();
    private FractionDetectionMode fractionDetectionMode = FractionDetectionMode.when_missing;
    private SimpleLogger log = STD_LOGGER;
    private boolean hollow;
    private DeclaredDependencies declaredDependencies;
    private final DefaultArtifactResolver resolver;
    private static final SimpleLogger STD_LOGGER = new SimpleLogger(){

        @Override
        public void info(String msg) {
            System.out.println(msg);
        }

        @Override
        public void error(String msg) {
            System.err.println(msg);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.error(msg);
            t.printStackTrace();
        }
    };
    public static final SimpleLogger STD_LOGGER_WITH_DEBUG = new SimpleLogger(){

        @Override
        public void debug(String msg) {
            System.out.println(msg);
        }

        @Override
        public void info(String msg) {
            System.out.println(msg);
        }

        @Override
        public void error(String msg) {
            System.err.println(msg);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.error(msg);
            t.printStackTrace();
        }
    };

    public BuildTool(ArtifactResolvingHelper resolvingHelper) {
        this.archive = ShrinkWrap.create(JavaArchive.class);
        this.resolver = new DefaultArtifactResolver(resolvingHelper);
        this.dependencyManager = new DependencyManager(this.resolver);
    }

    public BuildTool declaredDependencies(DeclaredDependencies declaredDependencies) {
        this.declaredDependencies = declaredDependencies;
        return this;
    }

    public BuildTool mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public BuildTool testClass(String testClass) {
        this.testClass = testClass;
        return this;
    }

    public BuildTool properties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public BuildTool bundleDependencies(boolean bundleDependencies) {
        this.bundleDependencies = bundleDependencies;
        return this;
    }

    public BuildTool projectArtifact(String groupId, String artifactId, String version, String packaging, File file) {
        this.projectArtifact(groupId, artifactId, version, packaging, file, null);
        return this;
    }

    public BuildTool projectArtifact(String groupId, String artifactId, String version, String packaging, File file, String artifactName) {
        this.projectAsset = new ArtifactAsset(new ArtifactSpec(null, groupId, artifactId, version, packaging, null, file), artifactName);
        this.dependencyManager.setProjectAsset(this.projectAsset);
        return this;
    }

    public BuildTool projectArchive(Archive archive) {
        this.projectAsset = new ArchiveAsset(archive);
        this.dependencyManager.setProjectAsset(this.projectAsset);
        return this;
    }

    public BuildTool fraction(ArtifactSpec spec) {
        this.fractions.add(spec);
        return this;
    }

    public BuildTool additionalModule(String module) {
        this.additionalModules.add(module);
        return this;
    }

    public BuildTool additionalModules(Collection<String> modules) {
        this.additionalModules.addAll(modules);
        return this;
    }

    public BuildTool resourceDirectory(String dir) {
        this.resourceDirectories.add(dir);
        return this;
    }

    public BuildTool fractionDetectionMode(FractionDetectionMode v) {
        this.fractionDetectionMode = v;
        return this;
    }

    public BuildTool executable(boolean executable) {
        this.executable = executable;
        return this;
    }

    public BuildTool executableScript(File executableScript) {
        this.executableScript = executableScript;
        return this;
    }

    public BuildTool hollow(boolean hollow) {
        this.hollow = hollow;
        return this;
    }

    public BuildTool logger(SimpleLogger logger) {
        this.log = logger;
        return this;
    }

    public BuildTool uberjarResourcesDirectory(Path dir) {
        this.uberjarResourcesDirectory = dir;
        return this;
    }

    public File build(String baseName, Path dir) throws Exception {
        this.build();
        return this.createJar(baseName, dir);
    }

    public void repackageWar(File file) throws IOException {
        this.log.info("Repackaging .war: " + file);
        Path backupPath = BuildTool.get(file);
        BuildTool.move(file, backupPath, this.log);
        Archive original = ShrinkWrap.create(JavaArchive.class);
        try (InputStream inputStream = Files.newInputStream(backupPath, new OpenOption[0]);){
            original.as(ZipImporter.class).importFrom(inputStream);
        }
        WebInfLibFilteringArchive repackaged = new WebInfLibFilteringArchive(original, this.dependencyManager);
        repackaged.as(ZipExporter.class).exportTo(file, true);
        this.log.info("Repackaged .war: " + file);
    }

    private static synchronized Path get(File file) {
        return Paths.get(file.toString() + ".original", new String[0]);
    }

    private static synchronized void move(File file, Path backupPath, SimpleLogger log) throws IOException {
        Path path = file.toPath();
        try {
            Files.move(path, backupPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.info("Fallback file move: " + file.getAbsolutePath());
            Files.copy(path, backupPath, StandardCopyOption.COPY_ATTRIBUTES);
            log.info("Copied " + path + " to " + backupPath);
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException del) {
                log.info("Fallback failed to delete, will overwrite existing file: " + file.getAbsolutePath());
            }
        }
    }

    public Archive build() throws Exception {
        if (null == this.declaredDependencies) {
            throw new IllegalStateException("Dependency declaration is not provided!");
        }
        this.analyzeDependencies(false);
        this.addWildflySwarmBootstrapJar();
        this.addJarManifest();
        this.addWildFlySwarmApplicationManifest();
        this.addAdditionalModules();
        this.addProjectAsset(this.dependencyManager);
        this.populateUberJarMavenRepository(this.dependencyManager);
        this.addUberjarResources();
        return this.archive;
    }

    private void addUberjarResources() {
        if (this.uberjarResourcesDirectory == null) {
            return;
        }
        if (!Files.exists(this.uberjarResourcesDirectory, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(this.uberjarResourcesDirectory, new LinkOption[0])) {
            return;
        }
        this.archive.as(ExplodedImporter.class).importDirectory(this.uberjarResourcesDirectory.toFile());
    }

    private boolean bootstrapJarShadesJBossModules(File artifactFile) throws IOException {
        boolean jbossModulesFound = false;
        try (JarFile jarFile = new JarFile(artifactFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry each = entries.nextElement();
                if (!each.getName().startsWith("org/jboss/modules/ModuleLoader")) continue;
                jbossModulesFound = true;
                break;
            }
        }
        return jbossModulesFound;
    }

    private void expandArtifact(File artifactFile) throws IOException {
        try {
            ZipFile zipFile = new ZipFile(artifactFile);
            for (FileHeader each : zipFile.getFileHeaders()) {
                if (each.getFileName().startsWith("META-INF") || each.isDirectory()) continue;
                this.archive.add((Asset)new ZipFileHeaderAsset(zipFile, each), each.getFileName());
            }
        }
        catch (ZipException e) {
            throw new IOException(e);
        }
    }

    private void analyzeDependencies(boolean autodetect) throws Exception {
        if (null == this.declaredDependencies) {
            throw new IllegalStateException("dependency declaration is not provided");
        }
        this.dependencyManager.analyzeDependencies(autodetect, this.declaredDependencies);
    }

    private void addProjectAsset(ResolvedDependencies resolvedDependencies) {
        if (this.hollow) {
            return;
        }
        this.archive.add(new WebInfLibFilteringArchiveAsset(this.projectAsset, this.dependencyManager));
    }

    private void detectFractions() throws Exception {
        File tmpFile = File.createTempFile("buildtool", this.projectAsset.getName().replace("/", "_"));
        tmpFile.deleteOnExit();
        this.projectAsset.getArchive().as(ZipExporter.class).exportTo(tmpFile, true);
        FractionUsageAnalyzer analyzer = new FractionUsageAnalyzer().logger(this.log).source(tmpFile);
        if (this.testClass != null && !"".equals(this.testClass)) {
            analyzer.testClass(this.testClass);
        }
        Collection<FractionDescriptor> detectedFractions = analyzer.detectNeededFractions();
        detectedFractions.removeAll(this.fractions.stream().map(ArtifactSpec::toFractionDescriptor).collect(Collectors.toSet()));
        this.log.info(String.format("Detected %sfractions: %s", this.fractions.isEmpty() ? "" : "additional ", String.join((CharSequence)", ", detectedFractions.stream().map(FractionDescriptor::av).sorted().collect(Collectors.toList()))));
        detectedFractions.stream().map(ArtifactSpec::fromFractionDescriptor).forEach(this::fraction);
    }

    private static String strippedSwarmGav(MavenArtifactDescriptor desc) {
        if (desc.groupId().equals("org.wildfly.swarm")) {
            return String.format("%s:%s", desc.artifactId(), desc.version());
        }
        return desc.mscGav();
    }

    private void addFractions(ResolvedDependencies resolvedDependencies) throws Exception {
        HashSet<ArtifactSpec> allFractions = new HashSet<ArtifactSpec>(this.fractions);
        this.fractions.stream().flatMap(s -> FractionList.get().getFractionDescriptor(s.groupId(), s.artifactId()).getDependencies().stream().map(ArtifactSpec::fromFractionDescriptor)).filter(d -> resolvedDependencies.findArtifact(d.groupId(), d.artifactId(), null, null, null) == null).forEach(allFractions::add);
        this.log.info("Adding fractions: " + String.join((CharSequence)", ", allFractions.stream().map(BuildTool::strippedSwarmGav).sorted().collect(Collectors.toList())));
        allFractions.forEach(f -> this.declaredDependencies.add(f));
        this.analyzeDependencies(true);
    }

    private void addWildflySwarmBootstrapJar() throws Exception {
        DependencyManager resolvedDependencies = this.dependencyManager;
        ArtifactSpec artifact = resolvedDependencies.findWildFlySwarmBootstrapJar();
        if (this.fractionDetectionMode != FractionDetectionMode.never && (this.fractionDetectionMode == FractionDetectionMode.force || artifact == null)) {
            this.log.info("Scanning for needed WildFly Swarm fractions with mode: " + (Object)((Object)this.fractionDetectionMode));
            this.detectFractions();
        }
        if (!this.fractions.isEmpty()) {
            this.addFractions(resolvedDependencies);
        }
        artifact = this.dependencyManager.findWildFlySwarmBootstrapJar();
        if (this.fractionDetectionMode == FractionDetectionMode.never && artifact == null) {
            this.log.error("No WildFly Swarm dependencies found and fraction detection disabled");
        }
        if (artifact != null) {
            if (!this.bootstrapJarShadesJBossModules(artifact.file)) {
                ArtifactSpec jbossModules = this.dependencyManager.findJBossModulesJar();
                this.expandArtifact(jbossModules.file);
            }
        } else {
            throw new IllegalStateException("No WildFly Swarm Bootstrap fraction found");
        }
        this.expandArtifact(artifact.file);
    }

    private void addJarManifest() {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.put(Attributes.Name.MAIN_CLASS, Main.class.getName());
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            manifest.write(out);
            out.close();
            byte[] bytes = out.toByteArray();
            this.archive.addAsManifestResource((Asset)new ByteArrayAsset(bytes), "MANIFEST.MF");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addWildFlySwarmApplicationManifest() {
        WildFlySwarmManifest manifest = this.dependencyManager.getWildFlySwarmManifest();
        this.properties.put("swarm.uberjar.build.user", System.getProperty("user.name"));
        if (!this.hollow) {
            this.properties.put("swarm.app.artifact", this.projectAsset.getSimpleName());
        }
        manifest.setProperties(this.properties);
        manifest.bundleDependencies(this.bundleDependencies);
        manifest.setMainClass(this.mainClass);
        manifest.setHollow(this.hollow);
        this.archive.add((Asset)new ByteArrayAsset(manifest.toString().getBytes(StandardCharsets.UTF_8)), "META-INF/wildfly-swarm-manifest.yaml");
    }

    public static File getOutputFile(String baseName, Path directory) {
        return new File(directory.toFile(), baseName + "-swarm.jar");
    }

    private File createJar(String baseName, Path dir) throws IOException {
        File out = BuildTool.getOutputFile(baseName, dir);
        if (!out.getParentFile().exists() && !out.getParentFile().mkdirs()) {
            this.log.error("Failed to create parent directory for: " + out.getAbsolutePath());
        }
        ZipExporter exporter = this.archive.as(ZipExporter.class);
        try (FileOutputStream fos = new FileOutputStream(out);){
            if (this.executable) {
                try (InputStream is = this.getLaunchScript();){
                    IOUtil.copy(is, fos);
                }
            }
            exporter.exportTo(fos);
        }
        if (this.executable && !out.setExecutable(true)) {
            this.log.error("Failed to set executable flag");
        }
        return out;
    }

    private InputStream getLaunchScript() throws IOException {
        return this.executableScript != null ? new FileInputStream(this.executableScript) : this.getClass().getResourceAsStream("launch.sh");
    }

    private void addAdditionalModules() throws IOException {
        for (String additionalModule : this.additionalModules) {
            File moduleDir = new File(additionalModule);
            this.archive.addAsResource(moduleDir, "modules");
            BuildTool.find(moduleDir, this.dependencyManager);
        }
    }

    private static synchronized void find(File moduleDir, DependencyManager dependencyManager) throws IOException {
        Files.find(moduleDir.toPath(), 20, (p, __) -> p.getFileName().toString().equals("module.xml"), new FileVisitOption[0]).forEach(dependencyManager::addAdditionalModule);
    }

    private void populateUberJarMavenRepository(ResolvedDependencies resolvedDependencies) throws Exception {
        if (this.bundleDependencies) {
            this.populateUberJarMavenRepository(this.archive, resolvedDependencies);
        } else {
            this.populateUserMavenRepository(resolvedDependencies);
        }
    }

    private void populateUberJarMavenRepository(Archive archive, ResolvedDependencies resolvedDependencies) throws Exception {
        HashSet<ArtifactSpec> alreadyResolved = new HashSet<ArtifactSpec>();
        ArrayList<ArtifactSpec> toBeResolved = new ArrayList<ArtifactSpec>();
        for (ArtifactSpec dependency : resolvedDependencies.getDependencies()) {
            boolean unresolved = !dependency.isResolved();
            boolean exploded = ResolvedDependencies.isExplodedBootstrap(dependency);
            if (unresolved || !exploded) {
                toBeResolved.add(dependency);
                continue;
            }
            alreadyResolved.add(dependency);
        }
        for (ArtifactSpec dependency : resolvedDependencies.getModuleDependencies()) {
            if (!dependency.isResolved()) {
                toBeResolved.add(dependency);
                continue;
            }
            alreadyResolved.add(dependency);
        }
        System.out.println("Resolving " + toBeResolved.size() + " out of " + (resolvedDependencies.getModuleDependencies().size() + resolvedDependencies.getDependencies().size()) + " artifacts");
        if (toBeResolved.size() > 0) {
            Collection<ArtifactSpec> newResolved = this.resolver.resolveAllArtifactsNonTransitively(toBeResolved);
            alreadyResolved.addAll(newResolved);
        }
        for (ArtifactSpec dependency : alreadyResolved) {
            this.addArtifactToArchiveMavenRepository(archive, dependency);
        }
    }

    private void populateUserMavenRepository(ResolvedDependencies resolvedDependencies) throws Exception {
        ArrayList<ArtifactSpec> toBeResolved = new ArrayList<ArtifactSpec>();
        toBeResolved.addAll(resolvedDependencies.getDependencies().stream().filter(a -> !a.isResolved()).collect(Collectors.toList()));
        toBeResolved.addAll(resolvedDependencies.getModuleDependencies().stream().filter(a -> !a.isResolved()).collect(Collectors.toList()));
        System.out.println("Resolving " + toBeResolved.size() + " out of " + (resolvedDependencies.getModuleDependencies().size() + resolvedDependencies.getDependencies().size()) + " artifacts");
        if (toBeResolved.size() > 0) {
            this.resolver.resolveAllArtifactsNonTransitively(toBeResolved);
        }
    }

    private void addArtifactToArchiveMavenRepository(Archive archive, ArtifactSpec artifact) throws Exception {
        if (!artifact.isResolved()) {
            throw new IllegalArgumentException("Artifact should be resolved!");
        }
        StringBuilder artifactPath = new StringBuilder("m2repo/");
        artifactPath.append(artifact.repoPath(true));
        archive.add((Asset)new FileAsset(artifact.file), artifactPath.toString());
    }

    public static enum FractionDetectionMode {
        when_missing,
        force,
        never;

    }
}

