/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.teiid;

import org.wildfly.swarm.config.Teiid;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.teiid.Transport;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@MarshalDMR
@WildFlyExtension(module="org.jboss.teiid", classname="org.teiid.jboss.TeiidExtension")
public class TeiidFraction
extends Teiid<TeiidFraction>
implements Fraction<TeiidFraction> {
    private static final long serialVersionUID = -6070901334377803127L;
    @Configurable(value="swarm.teiid.jdbc.port")
    @AttributeDocumentation(value="Set the port for the default JDBC socket listener")
    private Defaultable<Integer> jdbcPort = Defaultable.integer((int)31000);
    @Configurable(value="swarm.teiid.odbc.port")
    @AttributeDocumentation(value="Set the port for the default ODBC socket listener")
    private Defaultable<Integer> odbcPort = Defaultable.integer((int)35432);
    private boolean isJdbcTransportInstalled = false;

    public TeiidFraction applyDefaults() {
        return this.jdbcTransport();
    }

    public TeiidFraction jdbcTransport() {
        if (!this.isJdbcTransportInstalled) {
            this.transport("jdbc", t -> t.socketBinding("teiid-jdbc").protocol(Transport.Protocol.TEIID));
            this.isJdbcTransportInstalled = true;
        }
        return this;
    }

    public TeiidFraction odbcTransport() {
        return (TeiidFraction)this.transport("odbc", t -> t.socketBinding("teiid-odbc").protocol(Transport.Protocol.TEIID));
    }

    public TeiidFraction jdbcPort(int jdbcPort) {
        this.jdbcPort.set((Object)jdbcPort);
        return this;
    }

    public int jdbcPort() {
        return (Integer)this.jdbcPort.get();
    }

    public TeiidFraction odbcPort(int jdbcPort) {
        this.odbcPort.set((Object)jdbcPort);
        return this;
    }

    public int odbcPort() {
        return (Integer)this.odbcPort.get();
    }

    public String preparedplanCacheInfinispanContainer() {
        if (super.preparedplanCacheInfinispanContainer() == null) {
            super.preparedplanCacheInfinispanContainer("teiid-cache");
        }
        return super.preparedplanCacheInfinispanContainer();
    }

    public String preparedplanCacheName() {
        if (super.preparedplanCacheName() == null) {
            super.preparedplanCacheName("preparedplan");
        }
        return super.preparedplanCacheName();
    }

    public String resultsetCacheInfinispanContainer() {
        if (super.resultsetCacheInfinispanContainer() == null) {
            super.resultsetCacheInfinispanContainer("teiid-cache");
        }
        return super.resultsetCacheInfinispanContainer();
    }

    public String resultsetCacheName() {
        if (super.resultsetCacheName() == null) {
            super.resultsetCacheName("resultset");
        }
        return super.resultsetCacheName();
    }
}

