/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.teiid.runtime;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.wildfly.swarm.resource.adapters.ResourceAdapterFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@ApplicationScoped
public class ResourceAdapterCustomizer
implements Customizer {
    private static final String RAPRE = "org.jboss.teiid.resource-adapter.";
    @Inject
    private Instance<ResourceAdapterFraction> fraction;

    public void customize() throws Exception {
        HashMap<String, String> ras = new HashMap<String, String>();
        ras.put("org.jboss.teiid.resource-adapter.accumulo", "accumulo");
        ras.put("org.jboss.teiid.resource-adapter.cassandra", "cassandra");
        ras.put("org.jboss.teiid.resource-adapter.couchbase", "couchbase");
        ras.put("org.jboss.teiid.resource-adapter.file", "file");
        ras.put("org.jboss.teiid.resource-adapter.ftp", "ftp");
        ras.put("org.jboss.teiid.resource-adapter.google", "google");
        ras.put("org.jboss.teiid.resource-adapter.infinispan.hotrod", "infinispan");
        ras.put("org.jboss.teiid.resource-adapter.ldap", "ldap");
        ras.put("org.jboss.teiid.resource-adapter.mongodb", "mongodb");
        ras.put("org.jboss.teiid.resource-adapter.salesforce", "salesforce");
        ras.put("org.jboss.teiid.resource-adapter.salesforce-34", "salesforce-34");
        ras.put("org.jboss.teiid.resource-adapter.salesforce-41", "salesforce-41");
        ras.put("org.jboss.teiid.resource-adapter.simpledb", "simpledb");
        ras.put("org.jboss.teiid.resource-adapter.solr", "solr");
        ras.put("org.jboss.teiid.resource-adapter.webservice", "webservice");
        for (Map.Entry entry : ras.entrySet()) {
            this.loadResourceAdapter((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void loadResourceAdapter(String moduleName, String raName) throws ModuleLoadException {
        try {
            Module module = Module.getBootModuleLoader().loadModule(moduleName);
            if (module != null) {
                ((ResourceAdapterFraction)this.fraction.get()).resourceAdapter(raName, ra -> ra.module(moduleName));
            }
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            // empty catch block
        }
    }
}

