/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.teiid.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.spi.api.DefaultDeploymentFactory;
import org.wildfly.swarm.spi.api.DependenciesContainer;
import org.wildfly.swarm.teiid.VDBArchive;

@ApplicationScoped
public class DefaultVDBDeploymentFactory
extends DefaultDeploymentFactory {
    public static VDBArchive archiveFromCurrentApp() throws Exception {
        VDBArchive archive = (VDBArchive)ShrinkWrap.create(VDBArchive.class, (String)DefaultVDBDeploymentFactory.determineName());
        DefaultVDBDeploymentFactory factory = new DefaultVDBDeploymentFactory();
        factory.setup(archive);
        archive.addAllDependencies();
        return archive;
    }

    public int getPriority() {
        return 0;
    }

    public String getType() {
        return "vdb";
    }

    public Archive<?> create() throws Exception {
        return DefaultVDBDeploymentFactory.archiveFromCurrentApp();
    }

    public boolean setupUsingMaven(Archive<?> givenArchive) throws Exception {
        final DependenciesContainer archive = (DependenciesContainer)givenArchive;
        FileSystemLayout fsLayout = FileSystemLayout.create();
        final Path classes = fsLayout.resolveBuildClassesDir();
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), "classes/" + DefaultVDBDeploymentFactory.this.convertSeparators(simple));
                    if (simple.toString().contains("config")) {
                        archive.add((Asset)new FileAsset(file.toFile()), DefaultVDBDeploymentFactory.this.convertSeparators(simple));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        archive.addAllDependencies();
        return success;
    }

    protected static String determineName() {
        return DefaultDeploymentFactory.determineName((String)".vdb");
    }
}

