/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.camel.test.cdi.subA;

import javax.inject.Inject;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.Uri;
import org.apache.camel.component.mock.MockEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.swarm.camel.test.cdi.subA.Constants;

@ContextName(value="contextA")
public class RoutesContextA
extends RouteBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesContextA.class);
    @EndpointInject(uri="mock:A.b", context="contextA")
    public MockEndpoint b;
    @ContextName(value="contextA")
    @Inject
    @Uri(value="seda:A.a")
    Endpoint a;
    @ContextName(value="contextA")
    @Inject
    @Uri(value="seda:A.a")
    ProducerTemplate producer;

    public void configure() throws Exception {
        LOG.info("Adding route from " + this.a + " to " + this.b);
        this.from(this.a).to((Endpoint)this.b);
    }

    public void sendMessages() {
        for (Object expectedBody : Constants.EXPECTED_BODIES_A) {
            LOG.info("Sending " + expectedBody + " to " + this.producer.getDefaultEndpoint());
            this.producer.sendBody(expectedBody);
        }
    }
}

