/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jpa.swarm513;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.wildfly.swarm.jpa.swarm513.Ticket;
import org.wildfly.swarm.jpa.swarm513.TicketDTO;

@Stateless
@Path(value="/tickets")
public class TicketEndpoint {
    @PersistenceContext(unitName="primary")
    private EntityManager em;

    @POST
    @Consumes(value={"text/xml"})
    public Response create(TicketDTO dto) {
        Ticket entity = dto.fromDTO(null, this.em);
        this.em.persist((Object)entity);
        return Response.created((URI)UriBuilder.fromResource(TicketEndpoint.class).path(String.valueOf(entity.getId())).build(new Object[0])).build();
    }

    @GET
    @Produces(value={"text/xml", "application/json"})
    public List<TicketDTO> listAll(@QueryParam(value="start") Integer startPosition, @QueryParam(value="max") Integer maxResult) {
        TypedQuery findAllQuery = this.em.createQuery("SELECT DISTINCT t FROM Ticket t ORDER BY t.id", Ticket.class);
        if (startPosition != null) {
            findAllQuery.setFirstResult(startPosition.intValue());
        }
        if (maxResult != null) {
            findAllQuery.setMaxResults(maxResult.intValue());
        }
        List searchResults = findAllQuery.getResultList();
        ArrayList<TicketDTO> results = new ArrayList<TicketDTO>();
        for (Ticket searchResult : searchResults) {
            TicketDTO dto = new TicketDTO(searchResult.getId(), searchResult.getPrice());
            results.add(dto);
        }
        return results;
    }
}

