/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi.beanvalidation.test;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.wildfly.swarm.cdi.beanvalidation.test.Book;
import org.wildfly.swarm.cdi.beanvalidation.test.Isbn;

@ApplicationScoped
public class BooksService {
    private AtomicLong idGenerator = new AtomicLong();
    private List<Book> books = new CopyOnWriteArrayList<Book>();

    public List<Book> list() {
        return this.books;
    }

    @Valid
    public Book create(@Isbn(message="ISBN must be set to a valid value") String isbn, @NotNull(message="Title must be set") String title, @NotNull(message="Author must be set") String author) {
        Book book = new Book(this.idGenerator.incrementAndGet(), isbn, title, author);
        this.books.add(book);
        return book;
    }
}

