/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi.jaxrsapi.test;

import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.wildfly.swarm.cdi.jaxrsapi.test.TimeService;

@Path(value="/messages")
@ApplicationScoped
public class MessageResource {
    public static final String MESSAGE_PREFIX = "The date and time is ";
    @Inject
    TimeService timeService;

    @GET
    @Path(value="/sync")
    public String getMessageSync2Sync() throws Exception {
        String time = this.timeService.getTime();
        if (time != null) {
            return this.message(time);
        }
        return "Time service unavailable";
    }

    @GET
    @Path(value="/async")
    public void getMessageAsync2Sync(@Suspended AsyncResponse asyncResponse) throws Exception {
        this.timeService.exec(() -> this.timeService.getTime(), s -> asyncResponse.resume((Object)this.message((String)s)), arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0));
    }

    @GET
    @Path(value="/asyncZone")
    public void getMessageAsync2AsyncOffset(@Suspended AsyncResponse asyncResponse, @QueryParam(value="zoneId") String zoneId) throws Exception {
        this.timeService.exec(() -> this.timeService.getTimeForZone(zoneId), s -> asyncResponse.resume((Object)this.message((String)s)), arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0));
    }

    @GET
    @Path(value="/timeMessage")
    public void getTimeMessage(@Suspended AsyncResponse asyncResponse) throws Exception {
        ((CompletableFuture)((CompletableFuture)this.timeService.chainableExec(this.timeService::getTime, arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0)).thenApply(s -> this.timeService.addMessage((String)s))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(t -> {
            asyncResponse.resume(t);
            return null;
        });
    }

    @GET
    @Path(value="/hello/{name}")
    public String hello(@PathParam(value="name") String name) throws Exception {
        return this.timeService.hello(name);
    }

    private String message(String time) {
        System.err.println("Time received is: " + time);
        return MESSAGE_PREFIX + time;
    }
}

