/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi.jaxrsapi.test;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/time")
public class TimeResource {
    public static final String INTRO_MESSAGE = "Howdy at ";
    public static final String MESSAGE_HELLO = "Hello to ";

    @GET
    @Path(value="/default")
    @Produces(value={"text/plain"})
    public String getTime() {
        return ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    @GET
    @Path(value="/tz")
    @Produces(value={"text/plain"})
    public String getTimeForZone(@QueryParam(value="zoneId") String zoneId) {
        return ZonedDateTime.of(LocalDateTime.now(), ZoneId.of(zoneId)).format(DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    @GET
    @Path(value="/message")
    @Produces(value={"text/plain"})
    public String addMessage(@QueryParam(value="time") String time) {
        return INTRO_MESSAGE + time;
    }

    @GET
    @Path(value="/hello/{name}")
    @Produces(value={"text/plain"})
    public String hello(@PathParam(value="name") String name) throws Exception {
        return MESSAGE_HELLO + name;
    }
}

