/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.servlet.jpa.jta.test;

import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.UserTransaction;
import org.wildfly.swarm.servlet.jpa.jta.test.Book;

@WebServlet(value={"/"})
public class BooksServlet
extends HttpServlet {
    @PersistenceUnit(unitName="MyPU")
    private EntityManagerFactory emf;
    @Resource
    private UserTransaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try (EntityManager em = this.emf.createEntityManager();){
            List books = em.createNamedQuery("Book.getAll", Book.class).getResultList();
            for (Book book : books) {
                resp.getWriter().println(book.getId() + " " + book.getAuthor() + ": " + book.getTitle());
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String title = req.getParameter("title");
        String author = req.getParameter("author");
        try (EntityManager em = this.emf.createEntityManager();){
            this.tx.begin();
            Book book = new Book();
            book.setTitle(title);
            book.setAuthor(author);
            em.persist((Object)book);
            this.tx.commit();
            resp.getWriter().println(book.getId());
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int id = Integer.parseInt(req.getParameter("id"));
        try (EntityManager em = this.emf.createEntityManager();){
            this.tx.begin();
            Book book = (Book)em.find(Book.class, (Object)id);
            em.remove((Object)book);
            this.tx.commit();
            resp.getWriter().println(id + " deleted");
        }
    }
}

