/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.consul;

import java.net.MalformedURLException;
import java.net.URL;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.StageConfig;

public class ConsulTopologyFraction
implements Fraction {
    private static final URL DEFAULT_URL;
    private URL url = null;

    public void initialize(Fraction.InitContext initContext) {
        if (initContext.projectStage().isPresent()) {
            try {
                StageConfig stageConfig = (StageConfig)initContext.projectStage().get();
                String configvalue = (String)stageConfig.resolve("swarm.consul.url").withDefault(null).getValue();
                this.url = configvalue != null ? new URL(configvalue) : DEFAULT_URL;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Faile to resolve property 'swarm.consul.url'", e);
            }
        }
    }

    public ConsulTopologyFraction() {
    }

    public ConsulTopologyFraction(URL url) {
        this.url(url);
    }

    public ConsulTopologyFraction(String url) throws MalformedURLException {
        this.url(url);
    }

    public ConsulTopologyFraction url(URL url) {
        this.url = url;
        return this;
    }

    public ConsulTopologyFraction url(String url) throws MalformedURLException {
        this.url = new URL(url);
        return this;
    }

    public URL url() {
        return this.url;
    }

    static {
        URL tmp = null;
        try {
            String consulUrl = System.getProperty("swarm.consul.url", "http://localhost:8500/");
            tmp = new URL(consulUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        DEFAULT_URL = tmp;
    }
}

