/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.consul.runtime;

import com.orbitz.consul.AgentClient;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import java.net.URL;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.consul.runtime.Advertiser;
import org.wildfly.swarm.topology.consul.runtime.AgentClientService;
import org.wildfly.swarm.topology.consul.runtime.CatalogClientService;
import org.wildfly.swarm.topology.consul.runtime.CatalogWatcher;
import org.wildfly.swarm.topology.consul.runtime.ConsulService;
import org.wildfly.swarm.topology.consul.runtime.HealthClientService;
import org.wildfly.swarm.topology.runtime.Registration;
import org.wildfly.swarm.topology.runtime.TopologyConnector;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class ConsulTopologyConnector
implements Service<ConsulTopologyConnector>,
TopologyConnector {
    private final URL url;
    private InjectedValue<TopologyManager> topologyManagerInjector = new InjectedValue();
    private Advertiser advertiser;

    public ConsulTopologyConnector(URL url) {
        this.url = url;
    }

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }

    public void advertise(String name, SocketBinding binding, String ... tags) {
        Registration registration = new Registration("consul", name, binding.getAddress().getHostAddress(), binding.getAbsolutePort(), tags);
        this.advertiser.advertise(registration);
    }

    public void unadvertise(String name, SocketBinding binding) {
        this.advertiser.unadvertise(name, binding.getAddress().getHostAddress(), binding.getAbsolutePort());
    }

    public void start(StartContext startContext) throws StartException {
        ServiceTarget target = startContext.getChildTarget();
        ConsulService consul = new ConsulService(this.url);
        target.addService(ConsulService.SERVICE_NAME, (Service)consul).install();
        HealthClientService healthClient = new HealthClientService();
        target.addService(HealthClientService.SERIVCE_NAME, (Service)healthClient).addDependency(ConsulService.SERVICE_NAME, Consul.class, healthClient.getConsulInjector()).install();
        AgentClientService agentClient = new AgentClientService();
        target.addService(AgentClientService.SERVICE_NAME, (Service)agentClient).addDependency(ConsulService.SERVICE_NAME, Consul.class, agentClient.getConsulInjector()).install();
        CatalogClientService catalogClient = new CatalogClientService();
        target.addService(CatalogClientService.SERVICE_NAME, (Service)catalogClient).addDependency(ConsulService.SERVICE_NAME, Consul.class, catalogClient.getConsulInjector()).install();
        this.advertiser = new Advertiser();
        target.addService(Advertiser.SERVICE_NAME, (Service)this.advertiser).addDependency(AgentClientService.SERVICE_NAME, AgentClient.class, this.advertiser.getAgentClientInjector()).install();
        CatalogWatcher watcher = new CatalogWatcher();
        target.addService(CatalogWatcher.SERVICE_NAME, (Service)watcher).addDependency(CatalogClientService.SERVICE_NAME, CatalogClient.class, watcher.getCatalogClientInjector()).addDependency(HealthClientService.SERIVCE_NAME, HealthClient.class, watcher.getHealthClientInjector()).addDependency(TopologyManager.SERVICE_NAME, TopologyManager.class, watcher.getTopologyManagerInjector()).install();
    }

    public void stop(StopContext stopContext) {
    }

    public ConsulTopologyConnector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

