/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.consul.runtime;

import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.HealthClient;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.consul.runtime.Advertiser;
import org.wildfly.swarm.topology.consul.runtime.CatalogClientService;
import org.wildfly.swarm.topology.consul.runtime.CatalogWatcher;
import org.wildfly.swarm.topology.consul.runtime.HealthClientService;
import org.wildfly.swarm.topology.runtime.Registration;
import org.wildfly.swarm.topology.runtime.TopologyConnector;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class ConsulTopologyConnector
implements Service<ConsulTopologyConnector>,
TopologyConnector {
    private InjectedValue<TopologyManager> topologyManagerInjector = new InjectedValue();
    private InjectedValue<Advertiser> advertiser = new InjectedValue();

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }

    public Injector<Advertiser> getAdvertiserInjector() {
        return this.advertiser;
    }

    public void advertise(String name, SocketBinding binding, String ... tags) {
        Registration registration = new Registration("consul", name, binding.getAddress().getHostAddress(), binding.getAbsolutePort(), tags);
        this.getAdvertiser().advertise(registration);
    }

    private Advertiser getAdvertiser() {
        return (Advertiser)this.advertiser.getValue();
    }

    public void unadvertise(String name, SocketBinding binding) {
        this.getAdvertiser().unadvertise(name, binding.getAddress().getHostAddress(), binding.getAbsolutePort());
    }

    public void start(StartContext startContext) throws StartException {
        ServiceTarget target = startContext.getChildTarget();
        CatalogWatcher watcher = new CatalogWatcher();
        target.addService(CatalogWatcher.SERVICE_NAME, (Service)watcher).addDependency(CatalogClientService.SERVICE_NAME, CatalogClient.class, watcher.getCatalogClientInjector()).addDependency(HealthClientService.SERIVCE_NAME, HealthClient.class, watcher.getHealthClientInjector()).addDependency(TopologyManager.SERVICE_NAME, TopologyManager.class, watcher.getTopologyManagerInjector()).install();
    }

    public void stop(StopContext stopContext) {
        System.out.println(">>");
    }

    public ConsulTopologyConnector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

