/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.consul.runtime;

import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.cache.ServiceHealthCache;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.ImmutableCatalogOptions;
import com.orbitz.consul.option.ImmutableQueryOptions;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.consul.runtime.ConsulService;
import org.wildfly.swarm.topology.consul.runtime.ServiceCacheListener;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class CatalogWatcher
implements Service<CatalogWatcher>,
Runnable {
    public static final ServiceName SERVICE_NAME = ConsulService.SERVICE_NAME.append(new String[]{"catalog-watcher"});
    private InjectedValue<CatalogClient> catalogClientInjector = new InjectedValue();
    private InjectedValue<HealthClient> healthClientInjector = new InjectedValue();
    private InjectedValue<TopologyManager> topologyManagerInjector = new InjectedValue();
    private Thread thread;
    private Map<String, ServiceHealthCache> watchers = new HashMap<String, ServiceHealthCache>();

    public Injector<CatalogClient> getCatalogClientInjector() {
        return this.catalogClientInjector;
    }

    public Injector<HealthClient> getHealthClientInjector() {
        return this.healthClientInjector;
    }

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }

    public void start(StartContext startContext) throws StartException {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop(StopContext stopContext) {
        this.thread.interrupt();
        this.watchers.values().forEach(e -> {
            try {
                e.stop();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
    }

    public CatalogWatcher getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    @Override
    public void run() {
        CatalogClient client = (CatalogClient)this.catalogClientInjector.getValue();
        BigInteger index = null;
        while (true) {
            QueryOptions options = QueryOptions.BLANK;
            if (index != null) {
                options = ImmutableQueryOptions.builder().wait("60s").index(index).build();
            }
            ConsulResponse services = client.getServices(options);
            index = services.getIndex();
            Map response = (Map)services.getResponse();
            response.keySet().forEach(e -> this.setupWatcher((String)e));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                return;
            }
        }
    }

    private void setupWatcher(String serviceName) {
        if (this.watchers.containsKey(serviceName)) {
            return;
        }
        ImmutableCatalogOptions options = ImmutableCatalogOptions.builder().build();
        ServiceHealthCache healthCache = ServiceHealthCache.newCache((HealthClient)((HealthClient)this.healthClientInjector.getValue()), (String)serviceName, (boolean)true, (CatalogOptions)options, (int)5);
        try {
            healthCache.addListener((ConsulCache.Listener)new ServiceCacheListener(serviceName, (TopologyManager)this.topologyManagerInjector.getValue()));
            healthCache.start();
            healthCache.awaitInitialized(1L, TimeUnit.SECONDS);
            this.watchers.put(serviceName, healthCache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

