/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.consul.runtime;

import com.orbitz.consul.AgentClient;
import com.orbitz.consul.NotRegisteredException;
import com.orbitz.consul.model.agent.ImmutableRegistration;
import com.orbitz.consul.model.agent.Registration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.TopologyMessages;
import org.wildfly.swarm.topology.consul.runtime.ConsulService;
import org.wildfly.swarm.topology.runtime.Registration;

public class Advertiser
implements Service<Advertiser>,
Runnable {
    public static final ServiceName SERVICE_NAME = ConsulService.SERVICE_NAME.append(new String[]{"advertiser"});
    private static final Logger log = Logger.getLogger(Advertiser.class.getName());
    private InjectedValue<AgentClient> agentClientInjector = new InjectedValue();
    private Set<Registration> advertisements = Collections.newSetFromMap(new ConcurrentHashMap());
    private Thread thread;

    public Injector<AgentClient> getAgentClientInjector() {
        return this.agentClientInjector;
    }

    public void advertise(Registration registration) {
        if (this.advertisements.contains(registration)) {
            return;
        }
        AgentClient client = (AgentClient)this.agentClientInjector.getValue();
        ImmutableRegistration consulReg = ImmutableRegistration.builder().address(registration.getAddress()).port(registration.getPort()).id(this.serviceId(registration)).name(registration.getName()).addTags(registration.getTags().toArray(new String[0])).check(Registration.RegCheck.ttl((long)3L)).build();
        client.register((com.orbitz.consul.model.agent.Registration)consulReg);
        this.advertisements.add(registration);
        log.info("Registered service " + consulReg.getId());
    }

    public void unadvertise(String name, String address, int port) {
        AgentClient client = (AgentClient)this.agentClientInjector.getValue();
        Registration r = new Registration("consul", name, address, port, new String[]{""});
        this.advertisements.stream().filter(e -> e.equals((Object)r)).forEach(e -> {
            String serviceId = this.serviceId((Registration)e);
            log.info("Deregister service " + serviceId);
            client.deregister(serviceId);
        });
        this.advertisements.removeIf(e -> e.equals((Object)r));
    }

    public void start(StartContext startContext) throws StartException {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop(StopContext stopContext) {
        this.thread.interrupt();
    }

    public Advertiser getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void run() {
        AgentClient client = (AgentClient)this.agentClientInjector.getValue();
        while (true) {
            this.advertisements.stream().forEach(e -> {
                try {
                    client.pass(this.serviceId((Registration)e));
                }
                catch (NotRegisteredException ex) {
                    TopologyMessages.MESSAGES.notRegistered(e.toString(), (Throwable)ex);
                }
                catch (Exception ex) {
                    TopologyMessages.MESSAGES.errorOnCheck(e.toString(), (Throwable)ex);
                }
            });
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e2) {
                return;
            }
        }
    }

    private String serviceId(Registration registration) {
        return registration.getName() + ":" + registration.getAddress() + ":" + registration.getPort();
    }
}

