/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.consul.runtime;

import com.google.common.net.HostAndPort;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.model.health.ServiceHealth;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.swarm.topology.runtime.Registration;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class ServiceCacheListener
implements ConsulCache.Listener<HostAndPort, ServiceHealth> {
    private final String name;
    private final TopologyManager topologyManager;

    public ServiceCacheListener(String name, TopologyManager topologyManager) {
        this.name = name;
        this.topologyManager = topologyManager;
    }

    public void notify(Map<HostAndPort, ServiceHealth> newValues) {
        Set previousEntries = this.topologyManager.registrationsForService(this.name);
        Set newEntries = newValues.values().stream().map(e -> new Registration("consul", this.name, e.getService().getAddress(), e.getService().getPort(), new String[0]).addTags(e.getService().getTags())).collect(Collectors.toSet());
        previousEntries.stream().filter(e -> !newEntries.contains(e)).forEach(e -> this.topologyManager.unregister(e));
        newEntries.stream().filter(e -> !previousEntries.contains(e)).forEach(e -> this.topologyManager.register(e));
    }
}

