/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.jgroups.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.swarm.topology.jgroups.runtime.AdvertiseCommand;
import org.wildfly.swarm.topology.jgroups.runtime.RequestAdvertisementsCommand;
import org.wildfly.swarm.topology.jgroups.runtime.UnadvertiseCommand;
import org.wildfly.swarm.topology.runtime.Registration;
import org.wildfly.swarm.topology.runtime.TopologyConnector;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class JGroupsTopologyConnector
implements Service<JGroupsTopologyConnector>,
Group.Listener,
TopologyConnector {
    private InjectedValue<CommandDispatcherFactory> commandDispatcherFactoryInjector = new InjectedValue();
    private InjectedValue<TopologyManager> topologyManagerInjector = new InjectedValue();
    private CommandDispatcher<JGroupsTopologyConnector> dispatcher;
    private Node node;
    private Map<String, Registration> registrations = new ConcurrentHashMap<String, Registration>();

    public Injector<CommandDispatcherFactory> getCommandDispatcherFactoryInjector() {
        return this.commandDispatcherFactoryInjector;
    }

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }

    public void start(StartContext startContext) throws StartException {
        ((CommandDispatcherFactory)this.commandDispatcherFactoryInjector.getValue()).getGroup().addListener((Group.Listener)this);
        this.dispatcher = ((CommandDispatcherFactory)this.commandDispatcherFactoryInjector.getValue()).createCommandDispatcher((Object)"netflix.runtime.manager", (Object)this);
        this.node = ((CommandDispatcherFactory)this.commandDispatcherFactoryInjector.getValue()).getGroup().getLocalNode();
        this.requestAdvertisements();
    }

    public void stop(StopContext stopContext) {
        this.dispatcher.close();
    }

    public JGroupsTopologyConnector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void membershipChanged(List<Node> previousMembers, List<Node> members, boolean merged) {
        this.advertiseAll();
        ArrayList<Node> removed = new ArrayList<Node>();
        removed.addAll(previousMembers);
        removed.removeAll(members);
        removed.forEach(e -> ((TopologyManager)this.topologyManagerInjector.getValue()).unregisterAll(this.sourceKey((Node)e)));
    }

    protected void requestAdvertisements() {
        try {
            this.dispatcher.submitOnCluster((Command)new RequestAdvertisementsCommand(), new Node[]{this.node});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected synchronized void advertiseAll() {
        for (Registration each : ((TopologyManager)this.topologyManagerInjector.getValue()).registrationsForSourceKey(this.sourceKey(this.node))) {
            this.doAdvertise(each);
        }
    }

    public synchronized void advertise(String name, SocketBinding binding, String ... tags) {
        Registration registration = new Registration(this.sourceKey(this.node), name, binding.getAddress().getHostAddress(), binding.getAbsolutePort(), tags);
        this.registrations.put(name + ":" + binding.getName(), registration);
        this.advertise(registration);
    }

    public synchronized void advertise(Registration registration) {
        ((TopologyManager)this.topologyManagerInjector.getValue()).register(registration);
        this.doAdvertise(registration);
    }

    protected void doAdvertise(Registration registration) {
        try {
            this.dispatcher.submitOnCluster((Command)new AdvertiseCommand(registration), new Node[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void unadvertise(String appName, SocketBinding binding) {
        Registration registration = this.registrations.remove(appName + ":" + binding.getName());
        if (registration != null) {
            try {
                this.dispatcher.submitOnCluster((Command)new UnadvertiseCommand(registration), new Node[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void register(Registration registration) {
        ((TopologyManager)this.topologyManagerInjector.getValue()).register(registration);
    }

    void unregister(Registration registration) {
        ((TopologyManager)this.topologyManagerInjector.getValue()).unregister(registration);
    }

    String sourceKey(Node node) {
        return node.getName() + ":" + node.getSocketAddress().toString();
    }
}

