/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.openshift.runtime;

import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.IServicePort;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.openshift.runtime.OpenShiftTopologyConnector;
import org.wildfly.swarm.topology.runtime.Registration;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class ServiceWatcher
implements Service<ServiceWatcher>,
Runnable {
    public static final ServiceName SERVICE_NAME = OpenShiftTopologyConnector.SERVICE_NAME.append(new String[]{"service-watcher"});
    public static final int DEFAULT_HTTPS_PORT = 8443;
    private InjectedValue<IClient> clientInjector = new InjectedValue();
    private InjectedValue<String> namespaceInjector = new InjectedValue();
    private InjectedValue<TopologyManager> topologyManagerInjector = new InjectedValue();
    private Thread thread;

    public Injector<IClient> getClientInjector() {
        return this.clientInjector;
    }

    public Injector<String> getNamespaceInjector() {
        return this.namespaceInjector;
    }

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }

    public void start(StartContext context) throws StartException {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop(StopContext context) {
        this.thread.interrupt();
    }

    public ServiceWatcher getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void run() {
        IClient client = (IClient)this.clientInjector.getValue();
        String namespace = (String)this.namespaceInjector.getValue();
        TopologyManager topologyManager = (TopologyManager)this.topologyManagerInjector.getValue();
        while (!Thread.currentThread().isInterrupted()) {
            List services = client.list("Service", namespace);
            for (IService service : services) {
                Set previousEntries = topologyManager.registrationsForService(service.getName());
                Set<Registration> newEntries = this.registrationsForService(service);
                previousEntries.stream().filter(e -> !newEntries.contains(e)).forEach(arg_0 -> ((TopologyManager)topologyManager).unregister(arg_0));
                newEntries.stream().filter(e -> !previousEntries.contains(e)).forEach(arg_0 -> ((TopologyManager)topologyManager).register(arg_0));
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e2) {
                break;
            }
        }
    }

    private Set<Registration> registrationsForService(IService service) {
        HashSet<Registration> newEntries = new HashSet<Registration>();
        for (IServicePort servicePort : service.getPorts()) {
            if (servicePort.getPort() != service.getPort() && servicePort.getPort() != 8443) continue;
            Registration registration = new Registration("openshift", service.getName(), service.getPortalIP(), servicePort.getPort(), new String[0]);
            if (servicePort.getPort() == 8443) {
                registration.addTags(Collections.singletonList("https"));
            } else if (servicePort.getPort() == service.getPort()) {
                registration.addTags(Collections.singletonList("http"));
            }
            newEntries.add(registration);
        }
        return newEntries;
    }
}

