/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.openshift.runtime;

import com.openshift.restclient.ClientFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NoopSSLCertificateCallback;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.swarm.topology.openshift.runtime.OpenShiftTopologyConnector;

public class ClientService
implements Service<IClient> {
    public static final ServiceName SERVICE_NAME = OpenShiftTopologyConnector.SERVICE_NAME.append(new String[]{"client"});
    private IClient client;

    public static int servicePort(String serviceName) {
        String envName = serviceName.replace("-", "_").toUpperCase() + "_SERVICE_PORT";
        String envPort = System.getenv(envName);
        if (envPort == null) {
            return -1;
        }
        return Integer.parseInt(envPort);
    }

    public void start(StartContext context) throws StartException {
        try {
            this.client = this.openshiftClient();
            this.client.getCurrentUser().getName();
        }
        catch (IOException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    public void stop(StopContext context) {
        this.client = null;
    }

    public IClient getValue() throws IllegalStateException, IllegalArgumentException {
        return this.client;
    }

    private IClient openshiftClient() throws IOException {
        String kubeHost = this.serviceHost("kubernetes");
        int kubePort = ClientService.servicePort("kubernetes");
        Path tokenFile = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]);
        String scheme = "http";
        String token = null;
        if (Files.exists(tokenFile, new LinkOption[0])) {
            token = new String(Files.readAllBytes(tokenFile));
            scheme = "https";
        }
        IClient client = new ClientFactory().create(scheme + "://" + kubeHost + ":" + kubePort, (ISSLCertificateCallback)new NoopSSLCertificateCallback());
        if (token != null) {
            client.setAuthorizationStrategy((IAuthorizationStrategy)new TokenAuthorizationStrategy(token));
        }
        return client;
    }

    protected String serviceHost(String serviceName) {
        String envName = serviceName.replace("-", "_").toUpperCase() + "_SERVICE_HOST";
        return System.getenv(envName);
    }
}

