/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.openshift.runtime;

import com.openshift.restclient.IClient;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.openshift.runtime.ClientService;
import org.wildfly.swarm.topology.openshift.runtime.NamespaceService;
import org.wildfly.swarm.topology.openshift.runtime.ServiceWatcher;
import org.wildfly.swarm.topology.runtime.TopologyConnector;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class OpenShiftTopologyConnector
implements Service<OpenShiftTopologyConnector>,
TopologyConnector {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"swarm.topology.openshift"});
    private InjectedValue<TopologyManager> topologyManagerInjector = new InjectedValue();

    public void start(StartContext context) throws StartException {
        ServiceTarget target = context.getChildTarget();
        ClientService clientService = new ClientService();
        target.addService(ClientService.SERVICE_NAME, (Service)clientService).install();
        NamespaceService namespaceService = new NamespaceService();
        target.addService(NamespaceService.SERVICE_NAME, (Service)namespaceService).addDependency(ClientService.SERVICE_NAME, IClient.class, namespaceService.getClientInjector()).install();
        ServiceWatcher watcher = new ServiceWatcher();
        target.addService(ServiceWatcher.SERVICE_NAME, (Service)watcher).addDependency(ClientService.SERVICE_NAME, IClient.class, watcher.getClientInjector()).addDependency(NamespaceService.SERVICE_NAME, String.class, watcher.getNamespaceInjector()).addDependency(TopologyManager.SERVICE_NAME, TopologyManager.class, watcher.getTopologyManagerInjector()).install();
    }

    public void stop(StopContext context) {
    }

    public void advertise(String name, SocketBinding binding, String ... tags) {
    }

    public void unadvertise(String name, SocketBinding binding) {
    }

    public OpenShiftTopologyConnector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }
}

