/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.openshift.runtime;

import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.openshift.runtime.OpenShiftTopologyConnector;
import org.wildfly.swarm.topology.runtime.Registration;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class ServiceWatcher
implements Service<ServiceWatcher>,
IOpenShiftWatchListener {
    public static final ServiceName SERVICE_NAME = OpenShiftTopologyConnector.SERVICE_NAME.append(new String[]{"service-watcher"});
    public static final int DEFAULT_HTTPS_PORT = 8443;
    private static final String TOPOLOGY_SOURCE_KEY = "openshift";
    private InjectedValue<IClient> clientInjector = new InjectedValue();
    private InjectedValue<String> namespaceInjector = new InjectedValue();
    private InjectedValue<TopologyManager> topologyManagerInjector = new InjectedValue();
    private IWatcher openShiftWatcher;
    private AtomicReference<ListenerState> listenerState = new AtomicReference<ListenerState>(ListenerState.DISCONNECTED);

    public Injector<IClient> getClientInjector() {
        return this.clientInjector;
    }

    public Injector<String> getNamespaceInjector() {
        return this.namespaceInjector;
    }

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }

    public void start(StartContext context) throws StartException {
        this.startWatcher();
    }

    public void stop(StopContext context) {
        if (this.openShiftWatcher != null) {
            this.openShiftWatcher.stop();
        }
    }

    public ServiceWatcher getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private void startWatcher() {
        IClient client = (IClient)this.clientInjector.getValue();
        this.listenerState.set(ListenerState.STARTING);
        this.openShiftWatcher = client.watch((String)this.namespaceInjector.getValue(), (IOpenShiftWatchListener)this, new String[]{"Service"});
    }

    public void connected(List<IResource> resources) {
        this.listenerState.set(ListenerState.CONNECTED);
        resources.stream().filter(p -> p.getKind().equals("Service")).forEach(r -> {
            Set<Registration> regs = this.registrationsForService((IService)r);
            regs.forEach(arg_0 -> ((TopologyManager)((TopologyManager)this.topologyManagerInjector.getValue())).register(arg_0));
        });
    }

    public void disconnected() {
        if (this.listenerState.get().equals((Object)ListenerState.RESTARTING)) {
            return;
        }
        ((TopologyManager)this.topologyManagerInjector.getValue()).unregisterAll(TOPOLOGY_SOURCE_KEY);
        this.listenerState.set(ListenerState.DISCONNECTED);
    }

    public void received(IResource resource, IOpenShiftWatchListener.ChangeType change) {
        if (change.equals((Object)IOpenShiftWatchListener.ChangeType.ADDED)) {
            IService service = (IService)resource;
            this.registrationsForService(service).forEach(arg_0 -> ((TopologyManager)((TopologyManager)this.topologyManagerInjector.getValue())).register(arg_0));
        } else if (change.equals((Object)IOpenShiftWatchListener.ChangeType.DELETED)) {
            ((TopologyManager)this.topologyManagerInjector.getValue()).unregisterAll(TOPOLOGY_SOURCE_KEY, resource.getName());
        }
    }

    public void error(Throwable err) {
        this.restart();
    }

    private void restart() {
        switch (this.listenerState.get()) {
            case STARTING: 
            case DISCONNECTED: {
                return;
            }
        }
        if (this.openShiftWatcher != null) {
            this.listenerState.set(ListenerState.RESTARTING);
            this.openShiftWatcher.stop();
        }
        this.startWatcher();
    }

    private Set<Registration> registrationsForService(IService service) {
        HashSet<Registration> newEntries = new HashSet<Registration>();
        service.getPorts().stream().filter(servicePort -> servicePort.getPort() == service.getPort() || servicePort.getPort() == 8443).forEach(servicePort -> {
            Registration registration = new Registration(TOPOLOGY_SOURCE_KEY, service.getName(), service.getName(), servicePort.getPort(), new String[0]);
            if (servicePort.getPort() == 8443) {
                registration.addTags(Collections.singletonList("https"));
            } else if (servicePort.getPort() == service.getPort()) {
                registration.addTags(Collections.singletonList("http"));
            }
            newEntries.add(registration);
        });
        return newEntries;
    }

    private static enum ListenerState {
        STARTING,
        CONNECTED,
        RESTARTING,
        DISCONNECTED;

    }
}

