/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.topology.runtime.RegistrationAdvertiser;
import org.wildfly.swarm.topology.runtime.TopologyConnector;

public class RegistrationAdvertiserActivator
implements ServiceActivator {
    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceTarget target = context.getServiceTarget();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/swarm-topology-registration.conf");
        if (in == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String serviceName = null;
            while ((serviceName = reader.readLine()) != null) {
                if ((serviceName = serviceName.trim()).isEmpty()) continue;
                this.installAdvertiser(target, serviceName, "http");
                this.installAdvertiser(target, serviceName, "https");
            }
        }
        catch (IOException e) {
            throw new ServiceRegistryException((Throwable)e);
        }
    }

    private void installAdvertiser(ServiceTarget target, String serviceName, String socketBindingName) {
        ServiceName socketBinding = ServiceName.parse((String)("org.wildfly.network.socket-binding." + socketBindingName));
        RegistrationAdvertiser advertiser = new RegistrationAdvertiser(serviceName, socketBindingName);
        target.addService(ServiceName.of((String[])new String[]{"swarm", "topology", "register", serviceName, socketBindingName}), (Service)advertiser).addDependency(TopologyConnector.SERVICE_NAME, TopologyConnector.class, advertiser.getTopologyConnectorInjector()).addDependency(socketBinding, SocketBinding.class, advertiser.getSocketBindingInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }
}

