/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxy;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.host.Location;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.undertow.UndertowFraction;

public class TopologyWebAppFraction
implements Fraction {
    private Map<String, String> proxiedServiceMappings = new HashMap<String, String>();
    private boolean exposeTopologyEndpoint = true;

    public static String proxyHandlerName(String serviceName) {
        return serviceName + "-proxy-handler";
    }

    public void proxyService(String serviceName, String contextPath) {
        if (this.proxiedServiceMappings().containsValue(contextPath)) {
            throw new IllegalArgumentException("Cannot proxy multiple services under the same context path");
        }
        this.proxiedServiceMappings.put(serviceName, contextPath);
    }

    public Map<String, String> proxiedServiceMappings() {
        return this.proxiedServiceMappings;
    }

    public void exposeTopologyEndpoint(boolean exposeTopologyEndpoint) {
        this.exposeTopologyEndpoint = exposeTopologyEndpoint;
    }

    public boolean exposeTopologyEndpoint() {
        return this.exposeTopologyEndpoint;
    }

    public void postInitialize(Fraction.PostInitContext initContext) {
        if (!this.proxiedServiceMappings.isEmpty()) {
            UndertowFraction undertow = (UndertowFraction)initContext.fraction("undertow");
            HandlerConfiguration handlerConfig = undertow.subresources().handlerConfiguration();
            for (String serviceName : this.proxiedServiceMappings.keySet()) {
                ReverseProxy proxy = new ReverseProxy(TopologyWebAppFraction.proxyHandlerName(serviceName)).hosts(Collections.emptyList());
                handlerConfig.reverseProxy(proxy);
                String contextPath = this.proxiedServiceMappings.get(serviceName);
                for (Server server : undertow.subresources().servers()) {
                    Location location = new Location(contextPath).handler(TopologyWebAppFraction.proxyHandlerName(serviceName));
                    for (Host host : server.subresources().hosts()) {
                        host.location(location);
                    }
                }
            }
        }
    }
}

