/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.topology.TopologyArchive;
import org.wildfly.swarm.topology.webapp.TopologyWebAppFraction;
import org.wildfly.swarm.topology.webapp.runtime.TopologySSEServlet;
import org.wildfly.swarm.undertow.WARArchive;

public class TopologyWebAppConfiguration
extends AbstractServerConfiguration<TopologyWebAppFraction> {
    private static final String DEFAULT_CONTEXT = "/topology";

    public TopologyWebAppConfiguration() {
        super(TopologyWebAppFraction.class);
    }

    public List<Archive> getImplicitDeployments(TopologyWebAppFraction fraction) throws Exception {
        String context = System.getProperty("swarm.topology.context.path");
        if (context == null) {
            context = DEFAULT_CONTEXT;
        }
        ArrayList<Archive> list = new ArrayList<Archive>();
        WARArchive war = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)"topology-webapp.war");
        war.addAsWebInfResource((Asset)new StringAsset(this.getWebXml(fraction)), "web.xml");
        war.addClass(TopologySSEServlet.class);
        war.addModule("swarm.application");
        war.addModule("org.wildfly.swarm.topology");
        war.addAsWebResource((Asset)new ClassLoaderAsset("topology.js", ((Object)((Object)this)).getClass().getClassLoader()), "topology.js");
        war.setContextRoot(context);
        war.as(TopologyArchive.class);
        list.add((Archive)war);
        return list;
    }

    protected String getWebXml(TopologyWebAppFraction fraction) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee                        http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"    version=\"3.0\">    <context-param>        <param-name>externalAddressMapper</param-name>        <param-value>" + fraction.externalAddressMapper().getName() + "</param-value>" + "    </context-param>" + "</web-app>";
    }
}

