/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import io.undertow.server.handlers.proxy.ProxyHandler;
import java.util.Set;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.topology.runtime.TopologyConnector;
import org.wildfly.swarm.topology.webapp.runtime.TopologyProxyService;

public class TopologyWebAppActivator
implements ServiceActivator {
    private final Set<String> serviceNames;

    public TopologyWebAppActivator(Set<String> serviceNames) {
        this.serviceNames = serviceNames;
    }

    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceTarget target = context.getServiceTarget();
        TopologyProxyService proxyService = new TopologyProxyService(this.serviceNames);
        ServiceBuilder serviceBuilder = target.addService(TopologyProxyService.SERVICE_NAME, (Service)proxyService).addDependency(TopologyConnector.SERVICE_NAME);
        for (String serviceName : this.serviceNames) {
            serviceBuilder.addDependency(proxyService.mscServiceNameForServiceProxy(serviceName), ProxyHandler.class, proxyService.getHandlerInjectorFor(serviceName));
        }
        serviceBuilder.install();
    }
}

