/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.Topology;
import org.wildfly.swarm.topology.TopologyListener;
import org.wildfly.swarm.topology.webapp.TopologyWebAppFraction;

public class TopologyProxyService
implements Service<TopologyProxyService>,
TopologyListener {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"swarm.topology.proxy"});
    private static final Logger log = Logger.getLogger(TopologyProxyService.class.getName());
    private final Set<String> serviceNames;
    private Map<String, InjectedValue<ProxyHandler>> proxyHandlerMap = new HashMap<String, InjectedValue<ProxyHandler>>();
    private Map<String, List<Topology.Entry>> proxyEntries = new HashMap<String, List<Topology.Entry>>();

    public TopologyProxyService(Set<String> serviceNames) {
        this.serviceNames = serviceNames;
    }

    public ServiceName mscServiceNameForServiceProxy(String serviceName) {
        return ServiceName.of((String[])new String[]{"jboss", "undertow", "handler", TopologyWebAppFraction.proxyHandlerName((String)serviceName)});
    }

    public void start(StartContext context) throws StartException {
        try {
            Topology topology = Topology.lookup();
            topology.addListener((TopologyListener)this);
        }
        catch (NamingException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    public void stop(StopContext context) {
    }

    public TopologyProxyService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void onChange(Topology topology) {
        Map topologyMap = topology.asMap();
        for (String serviceName : this.serviceNames) {
            if (topologyMap.containsKey(serviceName)) {
                this.updateProxyHosts(serviceName, (List)topologyMap.get(serviceName));
                continue;
            }
            this.updateProxyHosts(serviceName, Collections.emptyList());
        }
    }

    public Injector<ProxyHandler> getHandlerInjectorFor(String serviceName) {
        InjectedValue injector = this.proxyHandlerMap.get(serviceName);
        if (injector == null) {
            injector = new InjectedValue();
            this.proxyHandlerMap.put(serviceName, (InjectedValue<ProxyHandler>)injector);
        }
        return injector;
    }

    private void updateProxyHosts(String serviceName, List<Topology.Entry> entries) {
        ProxyHandler proxyHandler = (ProxyHandler)this.proxyHandlerMap.get(serviceName).getValue();
        LoadBalancingProxyClient proxyClient = (LoadBalancingProxyClient)proxyHandler.getProxyClient();
        List<Topology.Entry> oldEntries = this.proxyEntries.get(serviceName);
        ArrayList<Topology.Entry> entriesToRemove = new ArrayList<Topology.Entry>();
        ArrayList<Topology.Entry> entriesToAdd = new ArrayList<Topology.Entry>();
        if (oldEntries == null) {
            entriesToAdd.addAll(entries);
        } else {
            for (Topology.Entry oldEntry : oldEntries) {
                if (entries.contains(oldEntry)) continue;
                entriesToRemove.add(oldEntry);
            }
            for (Topology.Entry entry : entries) {
                if (oldEntries.contains(entry)) continue;
                entriesToAdd.add(entry);
            }
        }
        for (Topology.Entry entry : entriesToRemove) {
            try {
                proxyClient.removeHost(this.entryToURI(entry));
            }
            catch (URISyntaxException ex) {
                log.log(Level.WARNING, "Error converting topology entry to URI", ex);
            }
        }
        for (Topology.Entry entry : entriesToAdd) {
            try {
                proxyClient.addHost(this.entryToURI(entry));
            }
            catch (URISyntaxException ex) {
                log.log(Level.WARNING, "Error converting topology entry to URI", ex);
            }
        }
        this.proxyEntries.put(serviceName, entries);
    }

    private URI entryToURI(Topology.Entry entry) throws URISyntaxException {
        List tags = entry.getTags();
        String scheme = "http";
        if (tags.contains("https")) {
            scheme = "https";
        }
        return new URI(scheme, null, entry.getAddress(), entry.getPort(), null, null, null);
    }
}

