/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.swarm.topology.Topology;
import org.wildfly.swarm.topology.TopologyListener;

@WebServlet(urlPatterns={"/system/stream"}, asyncSupported=true)
public class TopologySSEServlet
extends HttpServlet {
    private Topology topology;
    private ScheduledExecutorService keepAliveExecutor;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.topology = Topology.lookup();
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new ServletException();
        }
        this.keepAliveExecutor = Executors.newScheduledThreadPool(2);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/event-stream");
        resp.setCharacterEncoding("UTF-8");
        AsyncContext asyncContext = req.startAsync();
        PrintWriter writer = resp.getWriter();
        Object writeLock = new Object();
        final TopologyListener topologyListener = topo -> {
            String json = this.topologyToJson(req);
            Object object = writeLock;
            synchronized (object) {
                writer.write("event: topologyChange\n");
                writer.write("data: " + json);
                writer.flush();
            }
        };
        final ScheduledFuture<?> keepAlive = this.keepAliveExecutor.scheduleAtFixedRate(() -> {
            try {
                writer.write(":\n\n");
                writer.flush();
            }
            catch (Throwable t) {
                this.topology.removeListener(topologyListener);
                throw t;
            }
        }, 10L, 15L, TimeUnit.SECONDS);
        asyncContext.setTimeout(0L);
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                TopologySSEServlet.this.topology.removeListener(topologyListener);
                keepAlive.cancel(true);
            }

            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                TopologySSEServlet.this.topology.removeListener(topologyListener);
                keepAlive.cancel(true);
            }

            public void onError(AsyncEvent asyncEvent) throws IOException {
                TopologySSEServlet.this.topology.removeListener(topologyListener);
                keepAlive.cancel(true);
            }

            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }
        });
        this.topology.addListener(topologyListener);
        String json = this.topologyToJson(req);
        writer.write("event: topologyChange\n");
        writer.write("data: " + json);
        writer.flush();
    }

    protected String topologyToJson(HttpServletRequest req) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        Map map = this.topology.asMap();
        Set keys = map.keySet();
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            json.append("  ").append('\"').append(key).append('\"').append(": [");
            List list = (List)map.get(key);
            Iterator listIter = list.iterator();
            String proxyContext = this.getServletContext().getInitParameter(key + "-proxy");
            if (proxyContext != null) {
                ArrayList<String> tags = new ArrayList<String>();
                tags.add(req.isSecure() ? "https" : "http");
                while (listIter.hasNext()) {
                    Topology.Entry server = (Topology.Entry)listIter.next();
                    tags.add(server.getAddress() + ":" + server.getPort());
                }
                this.populateEndpointAndTagsJson(json, proxyContext, tags);
            } else {
                while (listIter.hasNext()) {
                    Topology.Entry server = (Topology.Entry)listIter.next();
                    boolean invalidServerAddress = false;
                    try {
                        InetAddress.getByName(server.getAddress());
                    }
                    catch (UnknownHostException e) {
                        invalidServerAddress = true;
                    }
                    String endpoint = (!invalidServerAddress ? (server.getTags().contains("https") ? "https" : "http") + "://" : "") + server.getAddress() + ":" + server.getPort();
                    this.populateEndpointAndTagsJson(json, endpoint, server.getTags());
                    if (!listIter.hasNext()) continue;
                    json.append(",");
                }
            }
            json.append("]");
            if (!keyIter.hasNext()) continue;
            json.append(",");
        }
        json.append("}\n\n");
        return json.toString();
    }

    protected void populateEndpointAndTagsJson(StringBuilder json, String endpoint, List<String> tags) {
        json.append("{");
        json.append("\"endpoint\": \"").append(endpoint).append("\",");
        json.append("\"tags\":[");
        Iterator<String> tagIter = tags.iterator();
        while (tagIter.hasNext()) {
            String tag = tagIter.next();
            json.append("\"").append(tag).append("\"");
            if (!tagIter.hasNext()) continue;
            json.append(",");
        }
        json.append("]");
        json.append("}");
    }
}

