/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxy;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.host.Location;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;
import org.wildfly.swarm.topology.webapp.TopologyWebAppFraction;
import org.wildfly.swarm.undertow.UndertowFraction;

@Post
@ApplicationScoped
public class TopologyProxiedServiceCustomizer
implements Customizer {
    @Inject
    @Any
    private UndertowFraction undertow;
    @Inject
    @Any
    private TopologyWebAppFraction fraction;

    public void customize() {
        Map<String, String> mappings = this.fraction.proxiedServiceMappings();
        if (!mappings.isEmpty()) {
            HandlerConfiguration handlerConfig = this.undertow.subresources().handlerConfiguration();
            for (String serviceName : mappings.keySet()) {
                ReverseProxy proxy = new ReverseProxy(TopologyWebAppFraction.proxyHandlerName(serviceName)).hosts(Collections.emptyList());
                handlerConfig.reverseProxy(proxy);
                String contextPath = mappings.get(serviceName);
                for (Server server : this.undertow.subresources().servers()) {
                    Location location = new Location(contextPath).handler(TopologyWebAppFraction.proxyHandlerName(serviceName));
                    for (Host host : server.subresources().hosts()) {
                        host.location(location);
                    }
                }
            }
        }
    }
}

