/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import io.undertow.server.HttpHandler;
import java.util.Set;
import javax.inject.Singleton;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.topology.runtime.TopologyManagerActivator;
import org.wildfly.swarm.topology.webapp.TopologyProxyService;

@Singleton
public class TopologyWebAppActivator
implements ServiceActivator {
    private final Set<String> serviceNames;

    public TopologyWebAppActivator(Set<String> serviceNames) {
        this.serviceNames = serviceNames;
    }

    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceTarget target = context.getServiceTarget();
        TopologyProxyService proxyService = new TopologyProxyService(this.serviceNames);
        ServiceBuilder serviceBuilder = target.addService(TopologyProxyService.SERVICE_NAME, (Service)proxyService).addDependency(TopologyManagerActivator.CONNECTOR_SERVICE_NAME);
        for (String serviceName : this.serviceNames) {
            serviceBuilder.addDependency(proxyService.mscServiceNameForServiceProxy(serviceName), HttpHandler.class, proxyService.getHandlerInjectorFor(serviceName));
        }
        serviceBuilder.install();
    }
}

