/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.topology.TopologyArchive;
import org.wildfly.swarm.topology.webapp.TopologyWebAppFraction;
import org.wildfly.swarm.topology.webapp.runtime.TopologySSEServlet;
import org.wildfly.swarm.undertow.WARArchive;

@Singleton
public class TopologyWebAppDeploymentProducer {
    @Inject
    private TopologyWebAppFraction fraction;
    @Inject
    @ConfigurationValue(value="swarm.topology.context.path")
    private String contextPath;

    @Produces
    @Dependent
    Archive deployment() {
        String context = "/topology";
        if (this.contextPath != null) {
            context = this.contextPath;
        }
        if (this.fraction.exposeTopologyEndpoint()) {
            WARArchive war = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)"topology-webapp.war");
            war.addAsWebInfResource((Asset)new StringAsset(this.getWebXml(this.fraction)), "web.xml");
            war.addClass(TopologySSEServlet.class);
            war.addModule("swarm.application");
            war.addModule("org.wildfly.swarm.topology");
            war.addAsWebResource((Asset)new ClassLoaderAsset("topology.js", this.getClass().getClassLoader()), "topology.js");
            war.setContextRoot(context);
            war.as(TopologyArchive.class);
            return war;
        }
        return null;
    }

    protected String getWebXml(TopologyWebAppFraction fraction) {
        String webXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee                        http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"    version=\"3.0\">";
        Map<String, String> proxiedServiceMappings = fraction.proxiedServiceMappings();
        for (String serviceName : proxiedServiceMappings.keySet()) {
            String contextPath = proxiedServiceMappings.get(serviceName);
            webXml = webXml + "    <context-param>        <param-name>" + serviceName + "-proxy</param-name>        <param-value>" + contextPath + "</param-value>    </context-param>";
        }
        webXml = webXml + "</web-app>";
        return webXml;
    }
}

