/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import io.undertow.server.HttpHandler;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.topology.runtime.TopologyManagerActivator;
import org.wildfly.swarm.topology.webapp.TopologyWebAppFraction;
import org.wildfly.swarm.topology.webapp.runtime.TopologyProxyService;

@ApplicationScoped
public class TopologyWebAppActivator
implements ServiceActivator {
    @Inject
    @Any
    private Instance<TopologyWebAppFraction> topologyWebAppFractionInstance;
    private Set<String> serviceNames = Collections.emptySet();

    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceTarget target = context.getServiceTarget();
        if (!this.topologyWebAppFractionInstance.isUnsatisfied()) {
            this.serviceNames = ((TopologyWebAppFraction)this.topologyWebAppFractionInstance.get()).proxiedServiceMappings().keySet();
        }
        TopologyProxyService proxyService = new TopologyProxyService(this.serviceNames);
        ServiceBuilder serviceBuilder = target.addService(TopologyProxyService.SERVICE_NAME, (Service)proxyService).addDependency(TopologyManagerActivator.CONNECTOR_SERVICE_NAME);
        for (String serviceName : this.serviceNames) {
            serviceBuilder.addDependency(proxyService.mscServiceNameForServiceProxy(serviceName), HttpHandler.class, proxyService.getHandlerInjectorFor(serviceName));
        }
        serviceBuilder.install();
    }
}

