/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;

@Configurable(value="swarm.topology.web-app")
public class TopologyWebAppFraction
implements Fraction<TopologyWebAppFraction> {
    public static final String DEFAULT_CONTEXT = "/topology";
    private Map<String, String> proxiedServiceMappings = new HashMap<String, String>();
    private boolean exposeTopologyEndpoint = true;

    public static String proxyHandlerName(String serviceName) {
        return serviceName + "-proxy-handler";
    }

    public void proxyService(String serviceName, String contextPath) {
        if (this.proxiedServiceMappings().containsValue(contextPath)) {
            throw new IllegalArgumentException("Cannot proxy multiple services under the same context path");
        }
        this.proxiedServiceMappings.put(serviceName, contextPath);
    }

    public Map<String, String> proxiedServiceMappings() {
        return this.proxiedServiceMappings;
    }

    public void exposeTopologyEndpoint(boolean exposeTopologyEndpoint) {
        this.exposeTopologyEndpoint = exposeTopologyEndpoint;
    }

    public boolean exposeTopologyEndpoint() {
        return this.exposeTopologyEndpoint;
    }
}

